<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <?php
    /**
     * @see arlo_qodef_header_meta() - hooked with 10
     * @see qode_user_scalable - hooked with 10
     */
    ?>
    <?php if (!arlo_qodef_is_ajax_request()) {
        do_action('arlo_qodef_header_meta');
    } ?>

    <?php if (!arlo_qodef_is_ajax_request()) {
        wp_head();
    } ?>

    <link rel="apple-touch-icon" sizes="180x180" href="apple-touch-icon.png">
    <link rel="icon" type="image/png" href="favicon-32x32.png" sizes="32x32">
    <link rel="icon" type="image/png" href="favicon-16x16.png" sizes="16x16">
    <link rel="manifest" href="manifest.json">
    <link rel="mask-icon" href="safari-pinned-tab.svg" color="#002750">
    <meta name="theme-color" content="#ffffff">
</head>

<body <?php body_class(); ?>>
<?php if (!arlo_qodef_is_ajax_request()) {
    arlo_qodef_get_side_area();
} ?>


<?php
if ((!arlo_qodef_is_ajax_request()) && arlo_qodef_options()->getOptionValue('smooth_page_transitions') == "yes") {
    $ajax_class = 'qodef-mimic-ajax';
    ?>
    <div class="qodef-smooth-transition-loader <?php echo esc_attr($ajax_class); ?>">
        <div class="qodef-st-loader">
            <div class="qodef-st-loader1">
                <?php arlo_qodef_loading_spinners(); ?>
            </div>
        </div>
    </div>
<?php } ?>

<div class="qodef-wrapper">
    <div class="qodef-wrapper-inner">
        <?php if (!arlo_qodef_is_ajax_request()) {
            arlo_qodef_get_header();
        } ?>

        <?php if ((!arlo_qodef_is_ajax_request()) && arlo_qodef_options()->getOptionValue('show_back_button') == "yes") { ?>
            <a id='qodef-back-to-top' href='#'>
                <span class="qodef-icon-stack">
                     <?php
                     arlo_qodef_icon_collections()->getBackToTopIcon('font_elegant');
                     ?>
                </span>
            </a>
        <?php } ?>
        <?php if (!arlo_qodef_is_ajax_request()) {
            arlo_qodef_get_full_screen_menu();
        } ?>

        <div class="qodef-content" <?php arlo_qodef_content_elem_style_attr(); ?>>
            <?php if (arlo_qodef_is_ajax_enabled()) { ?>
                <div class="qodef-meta">
                    <span id="qodef-page-id"><?php echo esc_html(get_queried_object_id()); ?></span>
                    <div class="qodef-body-classes"><?php echo esc_html(implode(',', get_body_class())); ?></div>
                </div>
            <?php } ?>
            <div class="qodef-content-inner">