<?php

/*** Child Theme Function  ***/

function arlo_qodef_enqueue_scripts()
{
    wp_register_style('childstyle', get_stylesheet_directory_uri() . '/style.css');
    wp_register_style('fontello', get_stylesheet_directory_uri() . '/css/wunder.css');
    wp_enqueue_style('childstyle');
    wp_enqueue_style('fontello');
}

add_action('wp_enqueue_scripts', 'arlo_qodef_enqueue_scripts', 11);

function aa_addFontello()
{
    class AAFontelloIconCollection implements iArloQodefIconCollection
    {
        public $icons = [];
        public $title = 'Fontello';
        public $param;
        public $styleUrl;


        /**
         * @param string $title title of icon collection
         * @param string $param param that will be used in shortcodes
         */
        public function __construct($title = '', $param = '')
        {
//            $this->icons = array(
//                'icon-anwendung' => '\e800',
//                'icon-musterformen' => '\e801',
//                'icon-serienformen' => '\e802',
//            );
//
            $this->icons = array(
                "icon-icons_anwendung" => "icon-icons_anwendung",
                "icon-icons_bauform" => "icon-icons_bauform" ,
                "icon-icons_engineering" => "icon-icons_engineering",
                "icon-icons_formenbau" => "icon-icons_formenbau",
                "icon-icons_geometrie" => "icon-icons_geometrie" ,
                "icon-icons_konstruktion" => "icon-icons_konstruktion" ,
                "icon-icons_kuehlung" => "icon-icons_kuehlung" ,
                "icon-icons_kunststofftechnik" => "icon-icons_kunststofftechnik" ,
                "icon-icons_musterformen" => "icon-icons_musterformen" ,
                "icon-icons_serienformen" => "icon-icons_serienformen" ,
                "icon-icons_varianten" => "icon-icons_varianten"
            );
            $this->title = $title;
            $this->param = $param;

        }

        /**
         * Method that returns $icons property
         * @return mixed
         */
        public function getIconsArray()
        {
            return $this->icons;
        }

        /**
         * Generates HTML for provided icon and parameters
         * @param $icon string
         * @param array $params
         * @return mixed
         */
        public function render($icon, $params = array())
        {
            $html = '';
            extract($params);
            $iconAttributesString = '';
            $iconClass = '';
            if (isset($icon_attributes) && count($icon_attributes)) {
                foreach ($icon_attributes as $icon_attr_name => $icon_attr_val) {
                    if ($icon_attr_name === 'class') {
                        $iconClass = $icon_attr_val;
                        unset($icon_attributes[$icon_attr_name]);
                    } else {
                        $iconAttributesString .= $icon_attr_name . ' = "' . $icon_attr_val . '" ';
                    }
                }
            }

            if (isset($before_icon) && $before_icon !== '') {
                $beforeIconAttrString = '';
                if (isset($before_icon_attributes) && count($before_icon_attributes)) {
                    foreach ($before_icon_attributes as $before_icon_attr_name => $before_icon_attr_val) {
                        $beforeIconAttrString .= $before_icon_attr_name . ' = "' . $before_icon_attr_val . '" ';
                    }
                }

                $html .= ' < ' . $before_icon . ' ' . $beforeIconAttrString . ' > ';
            }

            $html .= '<i class="icon ' . $icon . ' ' . $iconClass . '" ' . $iconAttributesString . ' ></i > ';

            if (isset($before_icon) && $before_icon !== '') {
                $html .= ' </' . $before_icon . ' > ';
            }

            return $html;
        }

        /**
         * Checks if icon collection has social icons
         * @return mixed
         */
        public function hasSocialIcons()
        {
            return false;
        }
    }

    $iconCollection = ArloQodefIconCollections::get_instance();
    $iconCollection->addIconCollection("fontello", new AAFontelloIconCollection('Wunder Fontello', 'icons'));


}

add_action('after_setup_theme', 'aa_addFontello');


