<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $product;

// Ensure visibility
if ( empty( $product ) || ! $product->is_visible() ) {
    return;
}
?>
<li <?php post_class(); ?>>
	<div class="qodef-product-image-holder">
		<?php
		/**
		 * woocommerce_before_shop_loop_item hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action( 'woocommerce_before_shop_loop_item' );
		?>
		<span class="qodef-original-image">
					<?php

					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked arlo_qodef_get_woocommerce_out_of_stock - 5
					 * @hooked woocommerce_show_product_loop_sale_flash - 10
					 * @hooked woocommerce_template_loop_product_thumbnail - 10
					 *
					 */
					do_action( 'woocommerce_before_shop_loop_item_title' );

					?>
					</span>
					<span class="qodef-hover-image">
					<?php

					/**
					 * woocommerce_before_shop_loop_item_title hook.
					 *
					 * @hooked arlo_qodef_woocommerce_shop_loop_hover_image - 10
					 *
					 */
					do_action('arlo_qodef_woocommerce_shop_loop_item_hover_image');

					?>
					</span>
		<?php

		/**
		 * woocommerce_before_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 15
		 *
		 */

		do_action('arlo_qodef_woocommerce_shop_loop_item_hover_link_close')

		?>

		<div class="qodef-product-button-holder">
			<?php do_action('arlo_qodef_woocommerce_shop_loop_product_simple_button'); ?>
		</div>
	</div>
	<div class="qodef-product-info-top">
		<?php

		/**
		 * woocommerce_shop_loop_item_title hook.
		 *
		 * @hooked woocommerce_template_loop_rating - 1
		 * @hooked woocommerce_template_loop_product_link_open - 5
		 * @hooked woocommerce_template_loop_product_title - 10
		 */
		do_action( 'woocommerce_shop_loop_item_title' );

		/**
		 * woocommerce_after_shop_loop_item_title hook.
		 *
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		do_action( 'woocommerce_after_shop_loop_item_title' );
		?>
	</div>
	<?php
	/**
	 * woocommerce_after_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_close - 5 - REMOVED
	 * @hooked woocommerce_template_loop_add_to_cart - 10 - REMOVED			 *
	 */
	do_action( 'woocommerce_after_shop_loop_item' );
	?>
</li>
