<?php

if (!function_exists('arlo_qodef_woocommerce_products_per_page')) {
	/**
	 * Function that sets number of products per page. Default is 12
	 * @return int number of products to be shown per page
	 */
	function arlo_qodef_woocommerce_products_per_page() {

		$products_per_page = 12;

		if (arlo_qodef_options()->getOptionValue('qodef_woo_products_per_page')) {
			$products_per_page = arlo_qodef_options()->getOptionValue('qodef_woo_products_per_page');
		}

		return $products_per_page;

	}

}

if (!function_exists('arlo_qodef_woocommerce_related_products_args')) {
	/**
	 * Function that sets number of displayed related products. Hooks to woocommerce_output_related_products_args filter
	 * @param $args array array of args for the query
	 * @return mixed array of changed args
	 */
	function arlo_qodef_woocommerce_related_products_args($args) {

		if (arlo_qodef_options()->getOptionValue('qodef_woo_product_list_columns')) {

			$related = arlo_qodef_options()->getOptionValue('qodef_woo_product_list_columns');
			switch ($related) {
				case 'qodef-woocommerce-columns-4':
					$args['posts_per_page'] = 4;
					break;
				case 'qodef-woocommerce-columns-3':
					$args['posts_per_page'] = 3;
					break;
				default:
					$args['posts_per_page'] = 3;
			}

		} else {
			$args['posts_per_page'] = 3;
		}

		return $args;

	}

}

if (!function_exists('arlo_qodef_woocommerce_template_loop_product_title')) {
	/**
	 * Function for overriding product title template in Product List Loop
	 */
	function arlo_qodef_woocommerce_template_loop_product_title() {

		$tag = arlo_qodef_options()->getOptionValue('qodef_products_list_title_tag');
		the_title('<' . $tag . ' class="qodef-product-list-product-title">', '</' . $tag . '>');

	}

}

if (!function_exists('arlo_qodef_woocommerce_template_single_title')) {
	/**
	 * Function for overriding product title template in Single Product template
	 */
	function arlo_qodef_woocommerce_template_single_title() {

		$tag = arlo_qodef_options()->getOptionValue('qodef_single_product_title_tag');
		the_title('<' . $tag . '  itemprop="name" class="qodef-single-product-title">', '</' . $tag . '>');

	}

}

if (!function_exists('arlo_qodef_woocommerce_sale_flash')) {
	/**
	 * Function for overriding Sale Flash Template
	 *
	 * @return string
	 */
	function arlo_qodef_woocommerce_sale_flash() {

		return '<span class="qodef-onsale"><span class="qodef-onsale-inner">' . esc_html__('Sale!', 'arlo') . '</span></span>';

	}

}

if (!function_exists('arlo_qodef_custom_override_checkout_fields')) {
	/**
	 * Overrides placeholder values for checkout fields
	 * @param array all checkout fields
	 * @return array checkout fields with overriden values
	 */
	function arlo_qodef_custom_override_checkout_fields($fields) {
		//billing fields
		$args_billing = array(
			'first_name'	=> esc_html__('First name','arlo'),
			'last_name'		=> esc_html__('Last name','arlo'),
			'company'		=> esc_html__('Company name','arlo'),
			'address_1'		=> esc_html__('Address','arlo'),
			'email'			=> esc_html__('Email','arlo'),
			'phone'			=> esc_html__('Phone','arlo'),
			'city'			=> esc_html__('City','arlo'),
			'postcode'		=> esc_html__('Postcode / ZIP','arlo'),
			'state'			=> esc_html__('State / County', 'arlo')
		);

		//shipping fields
		$args_shipping = array(
			'first_name' => esc_html__('First name','arlo'),
			'last_name'  => esc_html__('Last name','arlo'),
			'company'    => esc_html__('Company name','arlo'),
			'address_1'  => esc_html__('Address','arlo'),
			'postcode'   => esc_html__('Postcode / ZIP','arlo'),
			'city'		 => esc_html__('City','arlo')
		);

		//override billing placeholder values
		foreach ($args_billing as $key => $value) {
			$fields["billing"]["billing_{$key}"]["placeholder"] = $value;
		}

		//override shipping placeholder values
		foreach ($args_shipping as $key => $value) {
			$fields["shipping"]["shipping_{$key}"]["placeholder"] = $value;
		}

		return $fields;
	}

}

if (!function_exists('arlo_qodef_woocommerce_loop_add_to_cart_link')) {
	/**
	 * Function that overrides default woocommerce add to cart button on product list
	 * Uses HTML from qodef_button
	 *
	 * @return mixed|string
	 */
	function arlo_qodef_woocommerce_loop_add_to_cart_link() {

		global $product;

		$button_url = $product->add_to_cart_url();
		$button_classes = sprintf('%s %s product_type_%s',
			$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
			$product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
			esc_attr( $product->product_type )
		);
        $target =  $product->is_type( 'external' ) ? '_blank' : '_self';
		$button_text = $product->add_to_cart_text();
		$button_attrs = array(
			'rel' => 'nofollow',
			'data-product_id' => esc_attr( $product->id ),
			'data-product_sku' => esc_attr( $product->get_sku() ),
			'data-quantity' => esc_attr( isset( $quantity ) ? $quantity : 1 )
		);


		$add_to_cart_button = arlo_qodef_get_button_html(
			array(
				'link'			=> $button_url,
				'custom_class'	=> $button_classes,
				'text'			=> $button_text,
				'custom_attrs'	=> $button_attrs,
				'target'	    => $target
			)
		);

		return $add_to_cart_button;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_add_to_cart_button')) {
	/**
	 * Function that overrides default woocommerce add to cart button on simple and grouped product single template
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_get_woocommerce_add_to_cart_button() {

		global $product;

		$add_to_cart_button = arlo_qodef_get_button_html(
			array(
				'custom_class'	=> 'single_add_to_cart_button alt',
				'text'			=> $product->single_add_to_cart_text(),
				'html_type'		=> 'button'
			)
		);

		print $add_to_cart_button;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_add_to_cart_button_external')) {
	/**
	 * Function that overrides default woocommerce add to cart button on external product single template
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_get_woocommerce_add_to_cart_button_external() {

		global $product;

		$add_to_cart_button = arlo_qodef_get_button_html(
			array(
				'link'			=> $product->add_to_cart_url(),
				'custom_class'	=> 'single_add_to_cart_button alt',
				'text'			=> $product->single_add_to_cart_text(),
				'custom_attrs'	=> array(
					'rel' 		=> 'nofollow'
				),
                'target'        => '_blank'
			)
		);

		print $add_to_cart_button;

	}

}

if ( ! function_exists('arlo_qodef_woocommerce_single_variation_add_to_cart_button') ) {
	/**
	 * Function that overrides default woocommerce add to cart button on variable product single template
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_woocommerce_single_variation_add_to_cart_button() {
		global $product;

		$html = '<div class="variations_button">';
		woocommerce_quantity_input( array( 'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( $_POST['quantity'] ) : 1 ) );

		$button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'button',
			'custom_class'	=> 'single_add_to_cart_button alt',
			'text'			=> $product->single_add_to_cart_text()
		));

		$html .= $button;

		$html .= '<input type="hidden" name="add-to-cart" value="' . absint( $product->id ) . '" />';
		$html .= '<input type="hidden" name="product_id" value="' . absint( $product->id ) . '" />';
		$html .= '<input type="hidden" name="variation_id" class="variation_id" value="" />';
		$html .= '</div>';

		print $html;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_apply_coupon_button')) {
	/**
	 * Function that overrides default woocommerce apply coupon button
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_get_woocommerce_apply_coupon_button() {

		$coupon_button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'input',
			'input_name'	=> 'apply_coupon',
			'text'			=> esc_html__( 'Apply Coupon', 'arlo' )
		));

		print $coupon_button;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_update_cart_button')) {
	/**
	 * Function that overrides default woocommerce update cart button
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_get_woocommerce_update_cart_button() {

		$update_cart_button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'input',
			'input_name'	=> 'update_cart',
			'text'			=> esc_html__( 'Update Cart', 'arlo' )
		));

		print $update_cart_button;

	}

}

if (!function_exists('arlo_qodef_woocommerce_button_proceed_to_checkout')) {
	/**
	 * Function that overrides default woocommerce proceed to checkout button
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_woocommerce_button_proceed_to_checkout() {

		$proceed_to_checkout_button = arlo_qodef_get_button_html(array(
			'link'			=> WC()->cart->get_checkout_url(),
			'custom_class'	=> 'checkout-button alt wc-forward',
			'text'			=> esc_html__( 'Proceed to Checkout', 'arlo' )
		));

		print $proceed_to_checkout_button;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_update_totals_button')) {
	/**
	 * Function that overrides default woocommerce update totals button
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_get_woocommerce_update_totals_button() {

		$update_totals_button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'button',
			'text'			=> esc_html__( 'Update Totals', 'arlo' ),
			'custom_attrs'	=> array(
				'value'		=> 1,
				'name'		=> 'calc_shipping'
			)
		));

		print $update_totals_button;

	}

}

if (!function_exists('arlo_qodef_woocommerce_pay_order_button_html')) {
	/**
	 * Function that overrides default woocommerce pay order button on checkout page
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_woocommerce_pay_order_button_html() {

		$pay_order_button_text = esc_html__('Pay for order', 'arlo');

		$place_order_button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'input',
			'custom_class'	=> 'alt',
			'custom_attrs'	=> array(
				'id'			=> 'place_order',
				'data-value'	=> $pay_order_button_text
			),
			'text'			=> $pay_order_button_text,
		));

		return $place_order_button;

	}

}

if (!function_exists('arlo_qodef_woocommerce_order_button_html')) {
	/**
	 * Function that overrides default woocommerce place order button on checkout page
	 * Uses HTML from qodef_button
	 */
	function arlo_qodef_woocommerce_order_button_html() {

		$pay_order_button_text = esc_html__('Place Order', 'arlo');

		$place_order_button = arlo_qodef_get_button_html(array(
			'html_type'		=> 'input',
			'custom_class'	=> 'alt',
			'custom_attrs'	=> array(
				'id'			=> 'place_order',
				'data-value'	=> $pay_order_button_text,
				'name'			=> 'woocommerce_checkout_place_order'
			),
			'text'			=> $pay_order_button_text,
		));

		return $place_order_button;

	}

}

if (!function_exists('arlo_qodef_get_woocommerce_out_of_stock')) {
	/**
	 * Function that prints html with out of stock text if product is out of stock
	 */
	function arlo_qodef_get_woocommerce_out_of_stock(){

		global $product;

		if (!$product->is_in_stock()) {
			print '<span class="qodef-out-of-stock-button"><span class="qodef-out-of-stock-button-inner">' . esc_html__("Out of stock!", "arlo") . '</span></span>';
		}


	}
}

if (!function_exists('arlo_qodef_woocommerce_shop_loop_hover_image')) {
	/**
	 * Function that prints html with out of stock text if product is out of stock
	 */
	function arlo_qodef_woocommerce_shop_loop_hover_image(){

		global $product;

		$product_gallery_ids = $product->get_gallery_attachment_ids();
		if (!empty($product_gallery_ids)) {
			//get product image url, shop catalog size
			$product_hover_image = wp_get_attachment_image( $product_gallery_ids[0], 'shop_catalog' );
		}

		print $product_hover_image;
	}
}

if (!function_exists('arlo_qodef_woocommerce_loop_pagination')) {
	/**
	 * Function that overrides default woocommerce pagination in loop
	 *
	 */
	function arlo_qodef_woocommerce_loop_pagination() {
		$args = array();

		$args['prev_text'] = '<span class="arrow_left"></span>';
		$args['next_text'] = '<span class="arrow_right"></span>';
		$args['type'] = 'list';

		return $args;
	}
}


if (!function_exists('arlo_qodef_woocommerce_custom_tabs')) {
    /**
     * Function that overrides default tabs on product single page
     *
     */
    function arlo_qodef_woocommerce_custom_tabs() {
        global $product, $post;
        $tabs = array();

        // Description tab - shows product content
        if ( $post->post_content ) {
            $tabs['description'] = array(
                'title'    => __( 'Description', 'arlo' ),
                'priority' => 10,
                'callback' => 'woocommerce_product_description_tab'
            );
        }

        // Additional information tab - shows attributes
        if ( $product && ( $product->has_attributes() || ( $product->enable_dimensions_display() && ( $product->has_dimensions() || $product->has_weight() ) ) ) ) {
            $tabs['additional_information'] = array(
                'title'    => __( 'Additional Info', 'arlo' ),
                'priority' => 20,
                'callback' => 'woocommerce_product_additional_information_tab'
            );
        }

        // Reviews tab - shows comments
        if ( comments_open() ) {
            $tabs['reviews'] = array(
                'title'    => sprintf( __( 'Reviews (%d)', 'arlo' ), $product->get_review_count() ),
                'priority' => 30,
                'callback' => 'comments_template'
            );
        }

        return $tabs;
    }
}