<?php
/**
 * Woocommerce configuration file
 */

// Adds theme support for woocommerce
add_theme_support('woocommerce');

//Disable the default WooCommerce stylesheet.
if ( version_compare( WOOCOMMERCE_VERSION, "2.1" ) >= 0 ) {
	add_filter( 'woocommerce_enqueue_styles', '__return_false' );
} else {
	define( 'WOOCOMMERCE_USE_CSS', false );
}

if (!function_exists('arlo_qodef_woocommerce_content')){
	/**
	 * Output WooCommerce content.
	 *
	 * This function is only used in the optional 'woocommerce.php' template
	 * which people can add to their themes to add basic woocommerce support
	 * without hooks or modifying core templates.
	 *
	 * @access public
	 * @return void
	 */
	function arlo_qodef_woocommerce_content() {

		if ( is_singular( 'product' ) ) {

			while ( have_posts() ) : the_post();

				wc_get_template_part( 'content', 'single-product' );

			endwhile;

		} else {

			if ( have_posts() ) :

				do_action('woocommerce_before_shop_loop');

				woocommerce_product_loop_start();

				woocommerce_product_subcategories();

				while ( have_posts() ) : the_post();

					wc_get_template_part( 'content', 'product' );

				endwhile; // end of the loop.

				woocommerce_product_loop_end();

				do_action('woocommerce_after_shop_loop');

			elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) :

				wc_get_template( 'loop/no-products-found.php' );

			endif;

		}
	}
}

/* GENERAL SETTINGS START */

//Define number of products per page
add_filter('loop_shop_per_page', 'arlo_qodef_woocommerce_products_per_page', 20);

//Set number of related products
add_filter( 'woocommerce_output_related_products_args', 'arlo_qodef_woocommerce_related_products_args');

/* GENERAL SETTINGS END */

/* PRODUCT LIST START */

//Overide Product List Loop Title
remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
add_action( 'woocommerce_shop_loop_item_title', 'arlo_qodef_woocommerce_template_loop_product_title', 10 );

//Product List Title Add Link
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5 );
add_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 5 );

//Override Product List Loop Add To Cart
add_filter('woocommerce_loop_add_to_cart_link', 'arlo_qodef_woocommerce_loop_add_to_cart_link');

//Override Product List Rating
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_rating', 1 );

//Add Out Of Stock Label On Product List
add_action( 'woocommerce_before_shop_loop_item', 'arlo_qodef_get_woocommerce_out_of_stock', 5);

//Override Product List Link To Wrap Only Image
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);

//Override Product List Loop Pagination
add_filter('woocommerce_pagination_args', 'arlo_qodef_woocommerce_loop_pagination');

//Override Sale Label Position
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
add_action('woocommerce_before_shop_loop_item', 'woocommerce_show_product_loop_sale_flash', 5);

//Add product hover image
add_action('arlo_qodef_woocommerce_shop_loop_item_hover_image', 'arlo_qodef_woocommerce_shop_loop_hover_image', 10);

//Close link wrapped around images
add_action('arlo_qodef_woocommerce_shop_loop_item_hover_link_close', 'woocommerce_template_loop_product_link_close', 15);

//Override Product List Button Position
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
add_action('arlo_qodef_woocommerce_shop_loop_product_simple_button', 'woocommerce_template_loop_add_to_cart', 5);

/* PRODUCT LIST END */

/* SINGLE PRODUCT START */

//Single Product Title template override
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
add_action( 'woocommerce_single_product_summary', 'arlo_qodef_woocommerce_template_single_title', 5 );

//Single Product override tabs position
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
add_action('woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60);

//Change Position of product meta and add co cart button
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 30);
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 40);

//Override related products position
remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
add_action('qodef_arlo_woocommerce_related_products', 'woocommerce_output_related_products', 10);

//Override sale position
remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10);
add_action('arlo_qodef_woocommerce_single_product_sale_out_of_stock', 'woocommerce_show_product_sale_flash', 10);

//Add out of stock
add_action('arlo_qodef_woocommerce_single_product_sale_out_of_stock', 'arlo_qodef_get_woocommerce_out_of_stock', 10);

//Single product add social share)
add_action( 'woocommerce_share', 'arlo_qodef_woocommerce_share', 70);

//Override default tabs title
add_filter('woocommerce_product_tabs', 'arlo_qodef_woocommerce_custom_tabs');

/* SINGLE PRODUCT END */

//Sale flash template override
add_filter( 'woocommerce_sale_flash', 'arlo_qodef_woocommerce_sale_flash');

//Override Checkout Fields
add_filter('woocommerce_checkout_fields', 'arlo_qodef_custom_override_checkout_fields');

//Set Woocommerce button style
//Simple and grouped products
add_action('arlo_qodef_woocommerce_add_to_cart_button', 'arlo_qodef_get_woocommerce_add_to_cart_button');

//External product
add_action('arlo_qodef_woocommerce_add_to_cart_button_external', 'arlo_qodef_get_woocommerce_add_to_cart_button_external');

//Variable product
remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
add_action( 'woocommerce_single_variation', 'arlo_qodef_woocommerce_single_variation_add_to_cart_button', 20 );

//Apply Coupon Button
add_action('arlo_qodef_woocommerce_apply_coupon_button', 'arlo_qodef_get_woocommerce_apply_coupon_button');

//Update Cart
add_action('arlo_qodef_woocommerce_update_cart_button', 'arlo_qodef_get_woocommerce_update_cart_button');

//Proceed To Checkout Button
remove_action( 'woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20 );
add_action( 'woocommerce_proceed_to_checkout', 'arlo_qodef_woocommerce_button_proceed_to_checkout', 20 );

//Update Totals Button, Shipping Calculator
add_action('arlo_qodef_woocommerce_update_totals_button', 'arlo_qodef_get_woocommerce_update_totals_button');

//Pay For Order Button, Checkout page
add_filter('woocommerce_pay_order_button_html', 'arlo_qodef_woocommerce_pay_order_button_html');

//Place Order Button, Checkout page
add_filter('woocommerce_order_button_html', 'arlo_qodef_woocommerce_order_button_html');

