<?php
namespace ArloQodef\Modules\Shortcodes\UnderlineIconBox;

use ArloQodef\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class UnderlineIconBox
 */
class UnderlineIconBox implements ShortcodeInterface {

	/**
	 * @var string
	 */
	private $base;

	public function __construct() {
		$this->base = 'qodef_underline_icon_box';

		add_action('vc_before_init', array($this, 'vcMap'));
	}

	/**
	 * Returns base for shortcode
	 * @return string
	 */
	public function getBase() {
		return $this->base;
	}

	/**
	 * Maps shortcode to Visual Composer. Hooked on vc_before_init
	 *
	 * @see qode_core_get_carousel_slider_array_vc()
	 */
	public function vcMap() {

		vc_map( array(
			'name' => esc_html__('Select Underline Icon Box', 'arlo'),
			'base' => $this->getBase(),
			'category' => 'by SELECT',
			'icon' => 'icon-wpb-underline-icon-box extended-custom-icon',
			'allowed_container_element' => 'vc_row',
			'params' =>array_merge(
				arlo_qodef_icon_collections()->getVCParamsArray(),
			array(
					array(
						'type' => 'textfield',
						'heading' => 'Title',
						'param_name' => 'title',
						'admin_label' => true,
						'description' => ''
					),
					array(
						'type' => 'dropdown',
						'heading' => 'Title Tag',
						'param_name' => 'title_tag',
						'value' => array(
							''   => '',
							'h2' => 'h2',
							'h3' => 'h3',
							'h4' => 'h4',
							'h5' => 'h5',
							'h6' => 'h6',
						),
						'description' => ''
					),
					array(
						'type' => 'textfield',
						'heading' => 'Text',
						'param_name' => 'text',
						'admin_label' => true,
						'description' => ''
					),
					array(
						'type'        => 'colorpicker',
						'heading'     => 'Box Color',
						'param_name'  => 'background_color',
						'group'       => 'Design Options',
						'admin_label' => true
					),
					array(
						'type'        => 'colorpicker',
						'heading'     => 'Line Color',
						'param_name'  => 'line_color',
						'group'       => 'Design Options',
						'admin_label' => true
					)
				)
			)
		) );

	}

	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 * @param $content string shortcode content
	 * @return string
	 */
	public function render($atts, $content = null) {

		$default_atts = array(
			'title' => '',
			'title_tag' => 'h5',
			'text' => '',
			'background_color' => '',
			'line_color' => ''
		);

		$default_atts = array_merge($default_atts, arlo_qodef_icon_collections()->getShortcodeParams());
		$params       = shortcode_atts($default_atts, $atts);

		$params['icon_parameters'] = $this->getIconParameters($params);
		$params['holder_classes']  = $this->getHolderClasses($params);
		$params['box_style'] = $this->getBoxStyle($params);
		$params['line_style'] = $this->getLineStyle($params);

		//get correct heading value. If provided heading isn't valid get the default one
		$headings_array = array('h2', 'h3', 'h4', 'h5', 'h6');
		$params['title_tag'] = (in_array($params['title_tag'], $headings_array)) ? $params['title_tag'] : $default_atts['title_tag'];

		//Get HTML from template
		$html = arlo_qodef_get_shortcode_module_template_part('templates/underline-icon-box-template', 'underline-icon-box', '', $params);

		return $html;

	}

	private function getIconParameters($params) {
		$iconPackName = arlo_qodef_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);

		$params_array['icon_pack']   = $params['icon_pack'];
		$params_array[$iconPackName] = $params[$iconPackName];

		return $params_array;
	}

	private function getHolderClasses($params) {
		$classes = array('qodef-underline-icon-box-holder');
		$classes[] = 'center';

		return $classes;
	}

	private function getBoxStyle($params){
		$style = '';

		if($params['background_color'] !=''){
			$style ='background-color:'. $params['background_color'];
		}

		return $style;
	}

	private function getLineStyle($params){
		$style = '';

		if($params['line_color'] !=''){
			$style ='background-color:'. $params['line_color'];
		}

		return $style;
	}
}