<?php

if(!function_exists('arlo_qodef_tabs_map')) {
    function arlo_qodef_tabs_map() {
		
        $panel = arlo_qodef_add_admin_panel(array(
            'title' => 'Tabs',
            'name'  => 'panel_tabs',
            'page'  => '_elements_page'
        ));

        //Typography options
        arlo_qodef_add_admin_section_title(array(
            'name' => 'typography_section_title',
            'title' => 'Tabs Navigation Typography',			
            'parent' => $panel
        ));

        $typography_group = arlo_qodef_add_admin_group(array(
            'name' => 'typography_group',
            'title' => 'Tabs Navigation Typography',
			'description' => 'Setup typography for tabs navigation',
            'parent' => $panel
        ));

        $typography_row = arlo_qodef_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $typography_group
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'fontsimple',
            'name'          => 'tabs_font_family',
            'default_value' => '',
            'label'         => 'Font Family',
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_text_transform',
            'default_value' => '',
            'label'         => 'Text Transform',
            'options'       => arlo_qodef_get_text_transform_array()
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_style',
            'default_value' => '',
            'label'         => 'Font Style',
            'options'       => arlo_qodef_get_font_style_array()
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'textsimple',
            'name'          => 'tabs_letter_spacing',
            'default_value' => '',
            'label'         => 'Letter Spacing',
            'args'          => array(
                'suffix' => 'px'
            )
        ));

        $typography_row2 = arlo_qodef_add_admin_row(array(
            'name' => 'typography_row2',
            'next' => true,
            'parent' => $typography_group
        ));		
		
        arlo_qodef_add_admin_field(array(
            'parent'        => $typography_row2,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_weight',
            'default_value' => '',
            'label'         => 'Font Weight',
            'options'       => arlo_qodef_get_font_weight_array()
        ));
		
		//Light Tab Color Styles
		
		arlo_qodef_add_admin_section_title(array(
            'name' => 'tab_color_section_title',
            'title' => 'Light Tab Navigation Color Styles',
            'parent' => $panel
        ));
		$tabs_color_group = arlo_qodef_add_admin_group(array(
            'name' => 'tabs_color_group',
            'title' => 'Tab Navigation Color Styles',
			'description' => 'Set color styles for tab navigation',
            'parent' => $panel
        ));
		$tabs_color_row = arlo_qodef_add_admin_row(array(
            'name' => 'tabs_color_row',
            'next' => true,
            'parent' => $tabs_color_group
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color',
            'default_value' => '',
            'label'         => 'Color'
        ));
		arlo_qodef_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_back_color',
            'default_value' => '',
            'label'         => 'Background Color'
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color_active',
            'default_value' => '',
            'label'         => 'Hover Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_back_color_active',
            'default_value' => '',
            'label'         => ' Hover Background Color'
        ));

        //Dark Tab Color Styles

        arlo_qodef_add_admin_section_title(array(
            'name' => 'dark_tab_color_section_title',
            'title' => 'Dark Tab Navigation Color Styles',
            'parent' => $panel
        ));
        $dark_tabs_color_group = arlo_qodef_add_admin_group(array(
            'name' => 'dark_tabs_color_group',
            'title' => 'Tab Navigation Color Styles',
            'description' => 'Set color styles for tab navigation',
            'parent' => $panel
        ));
        $dark_tabs_color_row = arlo_qodef_add_admin_row(array(
            'name' => 'dark_tabs_color_row',
            'next' => true,
            'parent' => $dark_tabs_color_group
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $dark_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'dark_tabs_color',
            'default_value' => '',
            'label'         => 'Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $dark_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'dark_tabs_back_color',
            'default_value' => '',
            'label'         => 'Background Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $dark_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'dark_tabs_color_active',
            'default_value' => '',
            'label'         => 'Hover Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $dark_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'dark_tabs_back_color_active',
            'default_value' => '',
            'label'         => 'Hover Background Color'
        ));
    }

    add_action('arlo_qodef_options_elements_map', 'arlo_qodef_tabs_map');
}