<?php
if(!function_exists('arlo_qodef_tabs_typography_styles')){
	function arlo_qodef_tabs_typography_styles(){
		$selector = '.qodef-tabs .qodef-tabs-nav li a';
		$tabs_tipography_array = array();
		$font_family = arlo_qodef_options()->getOptionValue('tabs_font_family');
		
		if(arlo_qodef_is_font_option_valid($font_family)){
			$tabs_tipography_array['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}
		
		$text_transform = arlo_qodef_options()->getOptionValue('tabs_text_transform');
        if(!empty($text_transform)) {
            $tabs_tipography_array['text-transform'] = $text_transform;
        }

        $font_style = arlo_qodef_options()->getOptionValue('tabs_font_style');
        if(!empty($font_style)) {
            $tabs_tipography_array['font-style'] = $font_style;
        }

        $letter_spacing = arlo_qodef_options()->getOptionValue('tabs_letter_spacing');
        if($letter_spacing !== '') {
            $tabs_tipography_array['letter-spacing'] = arlo_qodef_filter_px($letter_spacing).'px';
        }

        $font_weight = arlo_qodef_options()->getOptionValue('tabs_font_weight');
        if(!empty($font_weight)) {
            $tabs_tipography_array['font-weight'] = $font_weight;
        }

        echo arlo_qodef_dynamic_css($selector, $tabs_tipography_array);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_tabs_typography_styles');
}

if(!function_exists('arlo_qodef_tabs_inital_color_styles')){
	function arlo_qodef_tabs_inital_color_styles(){
		$selector = '.qodef-tabs.qodef-light-tab .qodef-tabs-nav li a';
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('tabs_color')) {
            $styles['color'] = arlo_qodef_options()->getOptionValue('tabs_color');
        }
		if(arlo_qodef_options()->getOptionValue('tabs_back_color')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('tabs_back_color');
        }
		
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_tabs_inital_color_styles');
}
if(!function_exists('arlo_qodef_tabs_active_color_styles')){
	function arlo_qodef_tabs_active_color_styles(){
		$selector = '.qodef-tabs.qodef-light-tab .qodef-tabs-nav li.ui-state-active a, .qodef-tabs.qodef-light-tab .qodef-tabs-nav li.ui-state-hover a';
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('tabs_color_active')) {
            $styles['color'] = arlo_qodef_options()->getOptionValue('tabs_color_active');
        }
		if(arlo_qodef_options()->getOptionValue('tabs_back_color_active')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('tabs_back_color_active');
        }
		
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_tabs_active_color_styles');
}

if(!function_exists('arlo_qodef_dark_tabs_inital_color_styles')){
    function arlo_qodef_dark_tabs_inital_color_styles(){
        $selector = '.qodef-tabs.qodef-dark-tab .qodef-tabs-nav li a';
        $styles = array();

        if(arlo_qodef_options()->getOptionValue('dark_tabs_color')) {
            $styles['color'] = arlo_qodef_options()->getOptionValue('dark_tabs_color');
        }
        if(arlo_qodef_options()->getOptionValue('dark_tabs_back_color')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('dark_tabs_back_color');
        }

        echo arlo_qodef_dynamic_css($selector, $styles);
    }
    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_dark_tabs_inital_color_styles');
}
if(!function_exists('arlo_qodef_dark_tabs_active_color_styles')){
    function arlo_qodef_dark_tabs_active_color_styles(){
        $selector = '.qodef-tabs.qodef-dark-tab .qodef-tabs-nav li.ui-state-active a, .qodef-tabs.qodef-dark-tab .qodef-tabs-nav li.ui-state-hover a';
        $styles = array();

        if(arlo_qodef_options()->getOptionValue('dark_tabs_color_active')) {
            $styles['color'] = arlo_qodef_options()->getOptionValue('dark_tabs_color_active');
        }
        if(arlo_qodef_options()->getOptionValue('dark_tabs_back_color_active')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('dark_tabs_back_color_active');
        }

        echo arlo_qodef_dynamic_css($selector, $styles);
    }
    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_dark_tabs_active_color_styles');
}