<?php

if(!function_exists('arlo_qodef_progress_bar_map')) {
    function arlo_qodef_progress_bar_map() {

        $panel = arlo_qodef_add_admin_panel(array(
            'title' => 'Progress Bar',
            'name'  => 'panel_progress_bar',
            'page'  => '_elements_page'
        ));

        //Typography options
        arlo_qodef_add_admin_section_title(array(
            'name' => 'typography_progress_bar_title',
            'title' => 'Progress Bar Style',
            'parent' => $panel
        ));

        $color_group = arlo_qodef_add_admin_group(array(
            'name' => 'typography_group',
            'title' => 'Progress Bar Colors',
            'description' => 'Setup colors for progress bar parts',
            'parent' => $panel
        ));

        $color_row = arlo_qodef_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $color_group
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'progress_bar_title_color',
            'default_value' => '',
            'label'         => 'Title Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'progress_bar_number_background_color',
            'default_value' => '',
            'label'         => 'Number Background Color'
        ));

        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'progress_bar_number_color',
            'default_value' => '',
            'label'         => 'Number Color'
        ));
    }

    add_action('arlo_qodef_options_elements_map', 'arlo_qodef_progress_bar_map');
}