<?php
namespace ArloQodef\Modules\Shortcodes\ProcessItem;

use ArloQodef\Modules\Shortcodes\Lib\ShortcodeInterface;

class ProcessItem implements ShortcodeInterface{

    private $base;

    function __construct() {
        $this->base = 'qodef_process_item';
        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
                'name' => esc_html__('Process Item', 'arlo'),
                'base' => $this->base,
                'allowed_container_element' => 'vc_row',
                'as_child' => array('only' => 'qodef_process_holder'),
                'category' => 'by SELECT',
                'icon' => 'icon-wpb-process-item extended-custom-icon',
                'params' => array_merge(
                    array(
                        array(
                            'type' => 'textfield',
                            'heading' => 'Number',
                            'param_name' => 'number',
                            'admin_label' => true,
                            'description' => ''
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => 'Title',
                            'param_name' => 'title',
                            'admin_label' => true,
                            'description' => ''
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => 'Title Tag',
                            'param_name' => 'title_tag',
                            'value' => array(
                                ''   => '',
                                'h2' => 'h2',
                                'h3' => 'h3',
                                'h4' => 'h4',
                                'h5' => 'h5',
                                'h6' => 'h6',
                            ),
                            'description' => ''
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => 'Text',
                            'param_name' => 'text',
                            'admin_label' => true,
                            'description' => ''
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => 'Active',
                            'param_name' => 'active',
                            'value' => array(
                                ''      => '',
                                'No'    => 'no',
                                'Yes'   => 'yes'
                            ),
                            'description' => ''
                        ),
                    )
                )
            )
        );
    }

    public function render($atts, $content = null) {

        $args = array(
            'title' => '',
            'title_tag' => 'h5',
            'text' => '',
            'number' => '1',
            'active' => '',
        );

        $params = shortcode_atts($args, $atts);

        $params['class'] = $this->getActiveClass($params);

        $html = arlo_qodef_get_shortcode_module_template_part('templates/process-item-template', 'process', '', $params);

        return $html;
    }

    private function getActiveClass($params) {
        $class = '';
        if($params['active'] != '' && $params['active'] == 'yes') {
            $class .= 'active';
        }

        return $class;
    }


}