<?php
namespace ArloQodef\Modules\Shortcodes\Particles;

use ArloQodef\Modules\Shortcodes\Lib\ShortcodeInterface;

class Particles implements ShortcodeInterface{
	private $base;
	function __construct() {
		$this->base = 'qodef_particles';
		add_action('vc_before_init', array($this, 'vcMap'));
	}
	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map( array(
			"name" => "Interactive Dots",
			"base" => $this->base,
			"icon" => "icon-wpb-particles extended-custom-icon",
			"category" => 'by SELECT',
			'as_parent' => array('except' => 'qodef_portfolio_slider, qodef_particles, qodef_carousel'),
			"description" => "Create floating particles in the background.",
			"js_view" => 'VcColumnView',
			"params" => array(
				array(
					'type' => 'colorpicker',
					'holder' => 'div',
					'class' => '',
					'heading' => 'Dots Color',
					'param_name' => 'particles_color',
					'value' => '',
					'description' => 'Default color is #282d33'

				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => 'Dots Density',
					'param_name' => 'particles_density',
					'value' => '',
					'description' => 'Default value is 4000'
				),
				array(
					'type' => 'textfield',
					'holder' => 'div',
					'class' => '',
					'heading' => 'Dots Radius',
					'param_name' => 'particles_radius',
					'value' => '',
					'description' => 'Default value is 2'
				),
			)
		) );

	}

	public function render($atts, $content = null) {
		$args = array(
			'particles_color' => '#282d33',
			'particles_density' => '4000',
			'particles_radius' => '2'
        );

        extract(shortcode_atts($args, $atts));


        $data_string = ' '
		. (!empty($particles_color) ? 'data-particles-color="'.$particles_color.'" ' : '') . ' '
		. (!empty($particles_density) ? 'data-particles-density="'.$particles_density.'" ' : '') . ' '
		. (!empty($particles_radius) ? 'data-particles-radius="'.$particles_radius.'" ' : '') . ' ';

        $html = "";
        $html .= 
            '<div class="qodef-particles-holder">' .
				'<div class="qodef-particles" '. $data_string .'></div>' .
				do_shortcode($content) .
			'</div>';

        return $html;
	}
	
}
