<?php
namespace ArloQodef\Modules\Shortcodes\Lib;

use ArloQodef\Modules\Shortcodes\Accordion\Accordion;
use ArloQodef\Modules\Shortcodes\AccordionTab\AccordionTab;
use ArloQodef\Modules\Shortcodes\AnchorPoint\AnchorPoint;
use ArloQodef\Modules\Shortcodes\Blockquote\Blockquote;
use ArloQodef\Modules\Shortcodes\BlogList\BlogList;
use ArloQodef\Modules\Shortcodes\Button\Button;
use ArloQodef\Modules\Shortcodes\CallToAction\CallToAction;
use ArloQodef\Modules\Shortcodes\Counter\Countdown;
use ArloQodef\Modules\Shortcodes\Counter\Counter;
use ArloQodef\Modules\Shortcodes\CustomFont\CustomFont;
use ArloQodef\Modules\Shortcodes\Dropcaps\Dropcaps;
use ArloQodef\Modules\Shortcodes\ElementsHolder\ElementsHolder;
use ArloQodef\Modules\Shortcodes\ElementsHolderItem\ElementsHolderItem;
use ArloQodef\Modules\Shortcodes\GoogleMap\GoogleMap;
use ArloQodef\Modules\Shortcodes\Highlight\Highlight;
use ArloQodef\Modules\Shortcodes\Icon\Icon;
use ArloQodef\Modules\Shortcodes\IconListItem\IconListItem;
use ArloQodef\Modules\Shortcodes\IconWithText\IconWithText;
use ArloQodef\Modules\Shortcodes\ImageGallery\ImageGallery;
use ArloQodef\Modules\Shortcodes\Message\Message;
use ArloQodef\Modules\Shortcodes\OrderedList\OrderedList;
use ArloQodef\Modules\Shortcodes\PieCharts\PieChartBasic\PieChartBasic;
use ArloQodef\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartDoughnut;
use ArloQodef\Modules\Shortcodes\PieCharts\PieChartDoughnut\PieChartPie;
use ArloQodef\Modules\Shortcodes\PieCharts\PieChartWithIcon\PieChartWithIcon;
use ArloQodef\Modules\Shortcodes\PricingTables\PricingTables;
use ArloQodef\Modules\Shortcodes\PricingTable\PricingTable;
use ArloQodef\Modules\Shortcodes\ProgressBar\ProgressBar;
use ArloQodef\Modules\Shortcodes\Separator\Separator;
use ArloQodef\Modules\Shortcodes\SocialShare\SocialShare;
use ArloQodef\Modules\Shortcodes\Tabs\Tabs;
use ArloQodef\Modules\Shortcodes\Tab\Tab;
use ArloQodef\Modules\Shortcodes\Team\Team;
use ArloQodef\Modules\Shortcodes\UnorderedList\UnorderedList;
use ArloQodef\Modules\Shortcodes\VideoButton\VideoButton;
use ArloQodef\Modules\Shortcodes\ProcessItem\ProcessItem;
use ArloQodef\Modules\Shortcodes\ProcessHolder\ProcessHolder;
use ArloQodef\Modules\Shortcodes\UnderlineIconBox\UnderlineIconBox;
use ArloQodef\Modules\Shortcodes\Particles\Particles;


/**
 * Class ShortcodeLoader
 */
class ShortcodeLoader {
	/**
	 * @var private instance of current class
	 */
	private static $instance;
	/**
	 * @var array
	 */
	private $loadedShortcodes = array();

	/**
	 * Private constuct because of Singletone
	 */
	private function __construct() {}

	/**
	 * Private sleep because of Singletone
	 */
	private function __wakeup() {}

	/**
	 * Private clone because of Singletone
	 */
	private function __clone() {}

	/**
	 * Returns current instance of class
	 * @return ShortcodeLoader
	 */
	public static function getInstance() {
		if(self::$instance == null) {
			return new self;
		}

		return self::$instance;
	}

	/**
	 * Adds new shortcode. Object that it takes must implement ShortcodeInterface
	 * @param ShortcodeInterface $shortcode
	 */
	private function addShortcode(ShortcodeInterface $shortcode) {
		if(!array_key_exists($shortcode->getBase(), $this->loadedShortcodes)) {
			$this->loadedShortcodes[$shortcode->getBase()] = $shortcode;
		}
	}

	/**
	 * Adds all shortcodes.
	 *
	 * @see ShortcodeLoader::addShortcode()
	 */
	private function addShortcodes() {
		$this->addShortcode(new Accordion());
		$this->addShortcode(new AccordionTab());
		$this->addShortcode(new Blockquote());
		$this->addShortcode(new BlogList());
		$this->addShortcode(new Button());
		$this->addShortcode(new CallToAction());
		$this->addShortcode(new Counter());
		$this->addShortcode(new Countdown());
		$this->addShortcode(new CustomFont());
		$this->addShortcode(new Dropcaps());
		$this->addShortcode(new ElementsHolder());
		$this->addShortcode(new ElementsHolderItem());
		$this->addShortcode(new GoogleMap());
		$this->addShortcode(new Highlight());
		$this->addShortcode(new Icon());
		$this->addShortcode(new IconListItem());
		$this->addShortcode(new IconWithText());
		$this->addShortcode(new ImageGallery());
		$this->addShortcode(new Message());
		$this->addShortcode(new OrderedList());
		$this->addShortcode(new PieChartBasic());
		$this->addShortcode(new PieChartPie());
		$this->addShortcode(new PieChartDoughnut());
		$this->addShortcode(new PieChartWithIcon());
		$this->addShortcode(new PricingTables());
		$this->addShortcode(new PricingTable());
		$this->addShortcode(new ProgressBar());
		$this->addShortcode(new Separator());
		$this->addShortcode(new SocialShare());
		$this->addShortcode(new Tabs());
		$this->addShortcode(new Tab());
		$this->addShortcode(new Team());
		$this->addShortcode(new UnorderedList());
		$this->addShortcode(new VideoButton());
		$this->addShortcode(new ProcessHolder());
		$this->addShortcode(new ProcessItem());
		$this->addShortcode(new UnderlineIconBox());
		$this->addShortcode(new AnchorPoint());
		$this->addShortcode(new Particles());
	}
	/**
	 * Calls ShortcodeLoader::addShortcodes and than loops through added shortcodes and calls render method
	 * of each shortcode object
	 */
	public function load() {
		$this->addShortcodes();

		foreach ($this->loadedShortcodes as $shortcode) {
			add_shortcode($shortcode->getBase(), array($shortcode, 'render'));
		}
	}
}

$shortcodeLoader = ShortcodeLoader::getInstance();
$shortcodeLoader->load();