<?php

if(!function_exists('arlo_qodef_counter_map')) {
    function arlo_qodef_counter_map() {

        $panel = arlo_qodef_add_admin_panel(array(
            'title' => 'Counters',
            'name'  => 'panel_counter',
            'page'  => '_elements_page'
        ));

        //Color options
        arlo_qodef_add_admin_section_title(array(
            'name' => 'counter_section_colors',
            'title' => 'Counter Colors',
            'parent' => $panel
        ));

        $color_group = arlo_qodef_add_admin_group(array(
            'name' => 'color_group',
            'title' => 'Counter Colors',
            'description' => 'Setup colors for counter shortcodes',
            'parent' => $panel
        ));

        $color_row = arlo_qodef_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $color_group
        ));


        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'counter_number_color',
            'default_value' => '',
            'label'         => 'Number Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'counter_icon_color',
            'default_value' => '',
            'label'         => 'Icon Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'counter_title_color',
            'default_value' => '',
            'label'         => 'Title Color'
        ));
        arlo_qodef_add_admin_field(array(
            'parent'        => $color_row,
            'type'          => 'colorsimple',
            'name'          => 'counter_text_color',
            'default_value' => '',
            'label'         => 'Text Color'
        ));

    }

    add_action('arlo_qodef_options_elements_map', 'arlo_qodef_counter_map');
}