<?php

namespace ArloQodef\Modules\Shortcodes\BlogList;

use ArloQodef\Modules\Shortcodes\Lib\ShortcodeInterface;
/**
 * Class BlogList
 */
class BlogList implements ShortcodeInterface {
	/**
	* @var string
	*/
	private $base;
	
	function __construct() {
		$this->base = 'qodef_blog_list';
		
		add_action('vc_before_init', array($this,'vcMap'));

		//Category filter
		add_filter( 'vc_autocomplete_qodef_blog_list_category_callback', array( &$this, 'blogListCategoryAutocompleteSuggester', ), 10, 1 ); // Get suggestion(find). Must return an array

		//Category render
		add_filter( 'vc_autocomplete_qodef_blog_list_category_render', array( &$this, 'blogListCategoryAutocompleteRender', ), 10, 1 ); // Get suggestion(find). Must return an array

	}
	
	public function getBase() {
		return $this->base;
	}
	public function vcMap() {

		vc_map( array(
			'name' => esc_html__('Select Blog List', 'arlo'),
			'base' => $this->base,
			'icon' => 'icon-wpb-blog-list extended-custom-icon',
			'category' => 'by SELECT',
			'allowed_container_element' => 'vc_row',
			'params' => array(
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => esc_html__('Type', 'arlo'),
						'param_name' => 'type',
						'value' => array(
							'Boxes' => 'boxes',
							'Masonry' => 'masonry',
							'Minimal' => 'minimal',
							'Image in box' => 'image_in_box'
						),
						'description' => '',
                        'save_always' => true
					),
					array(
						'type' => 'textfield',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Number of Posts',
						'param_name' => 'number_of_posts',
						'description' => ''
					),
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Number of Columns',
						'param_name' => 'number_of_columns',
						'value' => array(
							'One' => '1',
							'Two' => '2',
							'Three' => '3',
							'Four' => '4'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes')),
                        'save_always' => true
					),
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Order By',
						'param_name' => 'order_by',
						'value' => array(
							'Title' => 'title',
							'Date' => 'date'
						),
						'save_always' => true,
						'description' => ''
					),
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Order',
						'param_name' => 'order',
						'value' => array(
							'ASC' => 'ASC',
							'DESC' => 'DESC'
						),
						'save_always' => true,
						'description' => ''
					),
					array(
						'type' => 'autocomplete',
						'heading' => 'Category Slug',
						'param_name' => 'category',
						'description' => 'Leave empty for all or use comma for list',
						'admin_label' => true
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Image',
						'param_name' => 'show_image',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes')),
						'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Image Size',
						'param_name' => 'image_size',
						'value' => array(
							'Original' => 'original',
							'Landscape' => 'landscape',
							'Square' => 'square'
						),
						'description' => '',
						'dependency' => Array('element' => 'show_image', 'value' => array('yes')),
                        'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'textfield',
						'holder' => 'div',
						'class' => '',
						'heading' => 'Text length',
						'param_name' => 'text_length',
						'description' => 'Number of characters',
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Title Tag',
						'param_name' => 'title_tag',
						'value' => array(
							''   => '',
							'h2' => 'h2',
							'h3' => 'h3',
							'h4' => 'h4',
							'h5' => 'h5',
							'h6' => 'h6',
						),
						'description' => '',
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Date',
						'param_name' => 'show_date',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes', 'masonry', 'image_in_box')),
						'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Category',
						'param_name' => 'show_category',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes', 'masonry', 'image_in_box')),
						'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Author',
						'param_name' => 'show_author',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes', 'masonry', 'image_in_box')),
						'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Comments',
						'param_name' => 'show_comments',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes', 'masonry', 'image_in_box')),
						'save_always' => true,
						'group' => 'Layout Options'
					),
					array(
						'type' => 'dropdown',
						'class' => '',
						'heading' => 'Show Likes',
						'param_name' => 'show_likes',
						'value' => array(
							'No' => 'no',
							'Yes' => 'yes'
						),
						'description' => '',
						'dependency' => Array('element' => 'type', 'value' => array('boxes', 'masonry', 'image_in_box')),
						'save_always' => true,
						'group' => 'Layout Options'
					)
				)
		) );

	}
	public function render($atts, $content = null) {
		
		$default_atts = array(
			'type' => 'boxes',
            'number_of_posts' => '',
            'number_of_columns' => '',
            'show_image' => '',
            'image_size' => 'original',
            'order_by' => '',
            'order' => '',
            'category' => '',
            'title_tag' => 'h5',
			'text_length' => '90',
			'show_date' => 'no',
			'show_category' => 'no',
			'show_author' => 'no',
			'show_comments' => 'no',
			'show_likes' => 'no'
        );
		
		$params = shortcode_atts($default_atts, $atts);
		extract($params);
		$params['holder_classes'] = $this->getBlogHolderClasses($params);
	
		$queryArray = $this->generateBlogQueryArray($params);
		$query_result = new \WP_Query($queryArray);
		$params['query_result'] = $query_result;	
     
		
        $thumbImageSize = $this->generateImageSize($params);
		$params['thumb_image_size'] = $thumbImageSize;

		$html = '';
        $html .= arlo_qodef_get_shortcode_module_template_part('templates/blog-list-holder', 'blog-list', '', $params);
		return $html;
		
	}

	/**
	   * Generates holder classes
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function getBlogHolderClasses($params){
		$holderClasses = '';
		
		$columnNumber = $this->getColumnNumberClass($params);
		
		if(!empty($params['type'])){
			switch($params['type']){
				case 'image_in_box':
					$holderClasses = 'qodef-image-in-box';
				break;
				case 'boxes' : 
					$holderClasses = 'qodef-boxes';
				break;	
				case 'masonry' : 
					$holderClasses = 'qodef-masonry';
				break;
				case 'minimal' :
					$holderClasses = 'qodef-minimal';
				break;	
				default: 
					$holderClasses = 'qodef-boxes';
			}
		}
		
		$holderClasses .= ' '.$columnNumber;
		
		return $holderClasses;
		
	}

	/** 
	   * Generates column classes for boxes type
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function getColumnNumberClass($params){
		
		$columnsNumber = '';
		$type = $params['type'];
		$columns = $params['number_of_columns'];
		
        if ($type == 'boxes') {
            switch ($columns) {
                case 1:
                    $columnsNumber = 'qodef-one-column';
                    break;
                case 2:
                    $columnsNumber = 'qodef-two-columns';
                    break;
                case 3:
                    $columnsNumber = 'qodef-three-columns';
                    break;
                case 4:
                    $columnsNumber = 'qodef-four-columns';
                    break;
                default:
					$columnsNumber = 'qodef-one-column';
                    break;
            }
        }
		return $columnsNumber;
	}

	/**
	   * Generates query array
	   *
	   * @param $params
	   *
	   * @return array
	*/
	public function generateBlogQueryArray($params){
		
		$queryArray = array(
			'orderby' => $params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['number_of_posts'],
			'category_name' => $params['category']
		);
		return $queryArray;
	}

	/**
	   * Generates image size option
	   *
	   * @param $params
	   *
	   * @return string
	*/
	private function generateImageSize($params){
		$thumbImageSize = '';
		$imageSize = $params['image_size'];
		
		if ($imageSize !== '' && $imageSize == 'landscape') {
            $thumbImageSize .= 'arlo_qodef_landscape';
        } else if($imageSize === 'square'){
			$thumbImageSize .= 'arlo_qodef_square';
		} else if ($imageSize !== '' && $imageSize == 'original') {
            $thumbImageSize .= 'full';
        }
		return $thumbImageSize;
	}

	/**
	 * Filter categories
	 *
	 * @param $query
	 *
	 * @return array
	 */
	public function blogListCategoryAutocompleteSuggester( $query ) {
		global $wpdb;
		$post_meta_infos = $wpdb->get_results( $wpdb->prepare( "SELECT a.slug AS slug, a.name AS category_title
					FROM {$wpdb->terms} AS a
					LEFT JOIN ( SELECT term_id, taxonomy  FROM {$wpdb->term_taxonomy} ) AS b ON b.term_id = a.term_id
					WHERE b.taxonomy = 'category' AND a.name LIKE '%%%s%%'", stripslashes( $query ) ), ARRAY_A );

		$results = array();
		if ( is_array( $post_meta_infos ) && ! empty( $post_meta_infos ) ) {
			foreach ( $post_meta_infos as $value ) {
				$data          = array();
				$data['value'] = $value['slug'];
				$data['label'] = ( ( strlen( $value['category_title'] ) > 0 ) ? esc_html__( 'Category', 'arlo' ) . ': ' . $value['category_title'] : '' );
				$results[]     = $data;
			}
		}

		return $results;

	}

	/**
	 * Find categories by slug
	 * @since 4.4
	 *
	 * @param $query
	 *
	 * @return bool|array
	 */
	public function blogListCategoryAutocompleteRender( $query ) {
		$query = trim( $query['value'] ); // get value from requested
		if ( ! empty( $query ) ) {
			// get category
			$category = get_term_by( 'slug', $query, 'category' );
			if ( is_object( $category ) ) {

				$category_slug = $category->slug;
				$category_title = $category->name;

				$category_title_display = '';
				if ( ! empty( $category_title ) ) {
					$category_title_display = esc_html__( 'Category', 'arlo' ) . ': ' . $category_title;
				}

				$data          = array();
				$data['value'] = $category_slug;
				$data['label'] = $category_title_display;

				return ! empty( $data ) ? $data : false;
			}

			return false;
		}

		return false;
	}
	
}
