<?php
namespace ArloQodef\Modules\Shortcodes\AnchorPoint;

use ArloQodef\Modules\Shortcodes\Lib\ShortcodeInterface;


/**
 * Class ProductList that represents product list shortcode
 * @package ArloQodef\Modules\Shortcodes\ProductList
 */
class AnchorPoint implements ShortcodeInterface {
    /**
     * @var string
     */
    private $base;

    /**
     * Sets base attribute and registers shortcode with Visual Composer
     */
    public function __construct() {
        $this->base = 'qodef_anchor_point';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base attribute
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer
     */
    public function vcMap() {
        vc_map(array(
            'name'                      => esc_html__('Select Anchor Point', 'arlo'),
            'base'                      => $this->base,
            'category'                  => 'by SELECT',
            'icon'                      => 'icon-wpb-anchor-point extended-custom-icon',
            'allowed_container_element' => 'vc_row',
            'params'                    => array(
                array(
                    'type' 			=> 'textfield',
                    'heading' 		=> 'Anchor',
                    'param_name' 	=> 'anchor',
                    'description' 	=> 'Enter anchor name'
                )
            )
        ));
    }

    /**
     * Renders HTML for product list shortcode
     *
     * @param array $atts
     * @param null $content
     *
     * @return string
     */
    public function render($atts, $content = null) {
        $default_atts = array(
            'anchor' => ''
        );

        $params = shortcode_atts($default_atts, $atts);

        $html = arlo_qodef_get_shortcode_module_template_part('templates/anchor-point-template', 'anchor-point', '', $params);

        return $html;
    }
}