<?php 

if(!function_exists('arlo_qodef_accordions_typography_styles')){
	function arlo_qodef_accordions_typography_styles(){
		$selector = '.qodef-accordion-holder .qodef-title-holder';		
		$styles = array();
		
		$font_family = arlo_qodef_options()->getOptionValue('accordions_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)){
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}
		
		$text_transform = arlo_qodef_options()->getOptionValue('accordions_text_transform');
       if(!empty($text_transform)) {
           $styles['text-transform'] = $text_transform;
       }

       $font_style = arlo_qodef_options()->getOptionValue('accordions_font_style');
       if(!empty($font_style)) {
           $styles['font-style'] = $font_style;
       }

       $letter_spacing = arlo_qodef_options()->getOptionValue('accordions_letter_spacing');
       if($letter_spacing !== '') {
           $styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing).'px';
       }

       $font_weight = arlo_qodef_options()->getOptionValue('accordions_font_weight');
       if(!empty($font_weight)) {
           $styles['font-weight'] = $font_weight;
       }

       echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_typography_styles');
}

if(!function_exists('arlo_qodef_accordions_inital_title_color_styles')){
	function arlo_qodef_accordions_inital_title_color_styles(){
		$selector = '.qodef-accordion-holder.qodef-initial .qodef-title-holder';
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('accordions_title_color')) {
           $styles['color'] = arlo_qodef_options()->getOptionValue('accordions_title_color');
       }
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_inital_title_color_styles');
}

if(!function_exists('arlo_qodef_accordions_initial_title_background_color_styles')){
    function arlo_qodef_accordions_initial_title_background_color_styles(){
        $selector = '.qodef-accordion-holder .qodef-title-holder .qodef-tab-title-inner';
        $styles = array();

        if(arlo_qodef_options()->getOptionValue('accordions_title_background_color')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('accordions_title_background_color');
        }
        echo arlo_qodef_dynamic_css($selector, $styles);
    }
    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_initial_title_background_color_styles');
}

if(!function_exists('arlo_qodef_accordions_active_title_color_styles')){
	
	function arlo_qodef_accordions_active_title_color_styles(){
		$selector = array(
			'.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-active',
			'.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-hover'
		);
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('accordions_title_color_active')) {
           $styles['color'] = arlo_qodef_options()->getOptionValue('accordions_title_color_active');
       }
		
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_active_title_color_styles');
}
if(!function_exists('arlo_qodef_accordions_active_title_background_color_styles')){
    function arlo_qodef_accordions_active_title_background_color_styles(){
        $selector = array(
            '.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-active .qodef-tab-title-inner',
            '.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-hover .qodef-tab-title-inner'
        );
        $styles = array();

        if(arlo_qodef_options()->getOptionValue('accordions_title_background_color_active')) {
            $styles['background-color'] = arlo_qodef_options()->getOptionValue('accordions_title_background_color_active');
        }
        echo arlo_qodef_dynamic_css($selector, $styles);
    }
    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_active_title_background_color_styles');
}
if(!function_exists('arlo_qodef_accordions_inital_icon_color_styles')){
	
	function arlo_qodef_accordions_inital_icon_color_styles(){
		$selector = '.qodef-accordion-holder.qodef-initial .qodef-title-holder .qodef-accordion-mark';
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('accordions_icon_color')) {
           $styles['color'] = arlo_qodef_options()->getOptionValue('accordions_icon_color');
       }
		if(arlo_qodef_options()->getOptionValue('accordions_icon_back_color')) {
           $styles['background-color'] = arlo_qodef_options()->getOptionValue('accordions_icon_back_color');
       }
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_inital_icon_color_styles');
}
if(!function_exists('arlo_qodef_accordions_active_icon_color_styles')){
	
	function arlo_qodef_accordions_active_icon_color_styles(){
		$selector = array(
			'.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-active  .qodef-accordion-mark',
			'.qodef-accordion-holder.qodef-initial .qodef-title-holder.ui-state-hover  .qodef-accordion-mark'
		);
		$styles = array();
		
		if(arlo_qodef_options()->getOptionValue('accordions_icon_color_active')) {
           $styles['color'] = arlo_qodef_options()->getOptionValue('accordions_icon_color_active');
       }
		if(arlo_qodef_options()->getOptionValue('accordions_icon_back_color_active')) {
           $styles['background-color'] = arlo_qodef_options()->getOptionValue('accordions_icon_back_color_active');
       }
		echo arlo_qodef_dynamic_css($selector, $styles);
	}
	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_accordions_active_icon_color_styles');
}