<?php

if (!function_exists('arlo_qodef_search_covers_header_style')) {

	function arlo_qodef_search_covers_header_style()
	{

		if (arlo_qodef_options()->getOptionValue('search_height') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-slide-header-bottom.qodef-animated .qodef-form-holder-outer, .qodef-search-slide-header-bottom .qodef-form-holder-outer, .qodef-search-slide-header-bottom', array(
				'height' => arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_height')) . 'px'
			));
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_covers_header_style');

}

if (!function_exists('arlo_qodef_search_opener_icon_size')) {

	function arlo_qodef_search_opener_icon_size()
	{

		if (arlo_qodef_options()->getOptionValue('header_search_icon_size')) {
			echo arlo_qodef_dynamic_css('.qodef-search-opener', array(
				'font-size' => arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('header_search_icon_size')) . 'px'
			));
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_opener_icon_size');

}

if (!function_exists('arlo_qodef_search_opener_icon_colors')) {

	function arlo_qodef_search_opener_icon_colors()
	{

		if (arlo_qodef_options()->getOptionValue('header_search_icon_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-opener', array(
				'color' => arlo_qodef_options()->getOptionValue('header_search_icon_color')
			));
		}

		if (arlo_qodef_options()->getOptionValue('header_search_icon_hover_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-opener:hover', array(
				'color' => arlo_qodef_options()->getOptionValue('header_search_icon_hover_color')
			));
		}

		if (arlo_qodef_options()->getOptionValue('header_light_search_icon_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-light-header .qodef-page-header > div:not(.qodef-sticky-header) .qodef-search-opener,
			.qodef-light-header.qodef-header-style-on-scroll .qodef-page-header .qodef-search-opener,
			.qodef-light-header .qodef-top-bar .qodef-search-opener', array(
				'color' => arlo_qodef_options()->getOptionValue('header_light_search_icon_color') . ' !important'
			));
		}

		if (arlo_qodef_options()->getOptionValue('header_light_search_icon_hover_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-light-header .qodef-page-header > div:not(.qodef-sticky-header) .qodef-search-opener:hover,
			.qodef-light-header.qodef-header-style-on-scroll .qodef-page-header .qodef-search-opener:hover,
			.qodef-light-header .qodef-top-bar .qodef-search-opener:hover', array(
				'color' => arlo_qodef_options()->getOptionValue('header_light_search_icon_hover_color') . ' !important'
			));
		}

		if (arlo_qodef_options()->getOptionValue('header_dark_search_icon_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-dark-header .qodef-page-header > div:not(.qodef-sticky-header) .qodef-search-opener,
			.qodef-dark-header.qodef-header-style-on-scroll .qodef-page-header .qodef-search-opener,
			.qodef-dark-header .qodef-top-bar .qodef-search-opener', array(
				'color' => arlo_qodef_options()->getOptionValue('header_dark_search_icon_color') . ' !important'
			));
		}
		if (arlo_qodef_options()->getOptionValue('header_dark_search_icon_hover_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-dark-header .qodef-page-header > div:not(.qodef-sticky-header) .qodef-search-opener:hover,
			.qodef-dark-header.qodef-header-style-on-scroll .qodef-page-header .qodef-search-opener:hover,
			.qodef-dark-header .qodef-top-bar .qodef-search-opener:hover', array(
				'color' => arlo_qodef_options()->getOptionValue('header_dark_search_icon_hover_color') . ' !important'
			));
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_opener_icon_colors');

}

if (!function_exists('arlo_qodef_search_opener_spacing')) {

	function arlo_qodef_search_opener_spacing()
	{
		$spacing_styles = array();

		if (arlo_qodef_options()->getOptionValue('search_padding_left') !== '') {
			$spacing_styles['padding-left'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_padding_left')) . 'px';
		}
		if (arlo_qodef_options()->getOptionValue('search_padding_right') !== '') {
			$spacing_styles['padding-right'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_padding_right')) . 'px';
		}
		if (arlo_qodef_options()->getOptionValue('search_margin_left') !== '') {
			$spacing_styles['margin-left'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_margin_left')) . 'px';
		}
		if (arlo_qodef_options()->getOptionValue('search_margin_right') !== '') {
			$spacing_styles['margin-right'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_margin_right')) . 'px';
		}

		if (!empty($spacing_styles)) {
			echo arlo_qodef_dynamic_css('.qodef-search-opener', $spacing_styles);
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_opener_spacing');
}

if (!function_exists('arlo_qodef_search_bar_background')) {

	function arlo_qodef_search_bar_background()
	{

		if (arlo_qodef_options()->getOptionValue('search_background_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-slide-header-bottom, .qodef-search-cover, .qodef-search-cover .qodef-container, .qodef-search-fade .qodef-fullscreen-search-holder .qodef-fullscreen-search-table, .qodef-fullscreen-search-overlay, .qodef-search-slide-window-top, .qodef-search-slide-window-top input[type="text"]', array(
				'background-color' => arlo_qodef_options()->getOptionValue('search_background_color')
			));
		}
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_bar_background');
}

if (!function_exists('arlo_qodef_search_text_styles')) {

	function arlo_qodef_search_text_styles()
	{
		$text_styles = array();

		if (arlo_qodef_options()->getOptionValue('search_text_color') !== '') {
			$text_styles['color'] = arlo_qodef_options()->getOptionValue('search_text_color');
		}
		if (arlo_qodef_options()->getOptionValue('search_text_fontsize') !== '') {
			$text_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_text_fontsize')) . 'px';
		}
		if (arlo_qodef_options()->getOptionValue('search_text_texttransform') !== '') {
			$text_styles['text-transform'] = arlo_qodef_options()->getOptionValue('search_text_texttransform');
		}
		if (arlo_qodef_options()->getOptionValue('search_text_google_fonts') !== '-1') {
			$text_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('search_text_google_fonts')) . ', sans-serif';
		}
		if (arlo_qodef_options()->getOptionValue('search_text_fontstyle') !== '') {
			$text_styles['font-style'] = arlo_qodef_options()->getOptionValue('search_text_fontstyle');
		}
		if (arlo_qodef_options()->getOptionValue('search_text_fontweight') !== '') {
			$text_styles['font-weight'] = arlo_qodef_options()->getOptionValue('search_text_fontweight');
		}
		if (arlo_qodef_options()->getOptionValue('search_text_letterspacing') !== '') {
			$text_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_text_letterspacing')) . 'px';
		}

		if (!empty($text_styles)) {
			echo arlo_qodef_dynamic_css('.qodef-search-slide-header-bottom input[type="text"], .qodef-search-cover input[type="text"], .qodef-fullscreen-search-holder .qodef-search-field, .qodef-search-slide-window-top input[type="text"]', $text_styles);
		}
		if (arlo_qodef_options()->getOptionValue('search_text_disabled_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-slide-header-bottom.qodef-disabled input[type="text"]::-webkit-input-placeholder, .qodef-search-slide-header-bottom.qodef-disabled input[type="text"]::-moz-input-placeholder', array(
				'color' => arlo_qodef_options()->getOptionValue('search_text_disabled_color')
			));
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_text_styles');
}

if (!function_exists('arlo_qodef_search_close_icon_styles')) {

	function arlo_qodef_search_close_icon_styles()
	{

		if (arlo_qodef_options()->getOptionValue('search_close_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-cover .qodef-search-close a span, .qodef-search-cover .qodef-search-close a i, .qodef-search-slide-window-top .qodef-search-close i,.qodef-search-slide-header-bottom .qodef-search-close a, .qodef-search-cover .qodef-search-close i, .qodef-fullscreen-search-close i', array(
				'color' => arlo_qodef_options()->getOptionValue('search_close_color')
			));
		}
		if (arlo_qodef_options()->getOptionValue('search_close_hover_color') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-cover .qodef-search-close a:hover span, .qodef-search-cover .qodef-search-close a:hover i, .qodef-search-slide-window-top .qodef-search-close i:hover, .qodef-search-slide-header-bottom .qodef-search-close a:hover, .qodef-search-cover .qodef-search-close i:hover, .qodef-fullscreen-search-close i:hover', array(
				'color' => arlo_qodef_options()->getOptionValue('search_close_hover_color')
			));
		}
		if (arlo_qodef_options()->getOptionValue('search_close_size') !== '') {
			echo arlo_qodef_dynamic_css('.qodef-search-cover .qodef-search-close a span, .qodef-search-cover .qodef-search-close a i, .qodef-search-slide-window-top .qodef-search-close i, .qodef-search-slide-header-bottom .qodef-search-close a, .qodef-search-cover .qodef-search-close i, .qodef-fullscreen-search-close i', array(
				'font-size' => arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('search_close_size')) . 'px'
			));
		}

	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_search_close_icon_styles');
}

?>
