<?php

if ( ! function_exists('arlo_qodef_like') ) {
	/**
	 * Returns ArloQodefLike instance
	 *
	 * @return ArloQodefLike
	 */
	function arlo_qodef_like() {
		return ArloQodefLike::get_instance();
	}

}

function arlo_qodef_get_like() {

	echo wp_kses(arlo_qodef_like()->add_like(), array(
		'span' => array(
			'class' => true,
			'aria-hidden' => true,
			'style' => true,
			'id' => true
		),
		'i' => array(
			'class' => true,
			'style' => true,
			'id' => true
		),
		'a' => array(
			'href' => true,
			'class' => true,
			'id' => true,
			'title' => true,
			'style' => true
		)
	));
}

if ( ! function_exists('arlo_qodef_like_latest_posts') ) {
	/**
	 * Add like to latest post
	 *
	 * @return string
	 */
	function arlo_qodef_like_latest_posts() {
		return arlo_qodef_like()->add_like();
	}

}

if ( ! function_exists('arlo_qodef_like_portfolio_list') ) {
	/**
	 * Add like to portfolio project
	 *
	 * @param $portfolio_project_id
	 * @return string
	 */
	function arlo_qodef_like_portfolio_list($portfolio_project_id) {
		return arlo_qodef_like()->add_like_portfolio_list($portfolio_project_id);
	}

}