<?php
if(!function_exists('arlo_qodef_contact_form7_text_styles_1')) {
	/**
	 * Generates custom styles for Contact Form 7 elements
	 */
	function arlo_qodef_contact_form7_text_styles_1() {
		$selector = array(
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date',
			'.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea',
			'.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_1_text_color');
		if($color !== ''){
			$styles['color'] = $color;
			echo arlo_qodef_dynamic_css(
			array(
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text::-webkit-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number::-webkit-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date::-webkit-input-placeholder',
                '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea::-webkit-input-placeholder',
                '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select::-webkit-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz::-webkit-input-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:-moz-placeholder',
                '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:-moz-placeholder',
                '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:-moz-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text::-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number::-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date::-moz-placeholder',
                '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea::-moz-placeholder',
                '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select::-moz-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz::-moz-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:-ms-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:-ms-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:-ms-input-placeholder',
                '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:-ms-input-placeholder',
                '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:-ms-input-placeholder',
                '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:-ms-input-placeholder'
            ),
			array('color' => $color)
			);
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_1_text_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$line_height = arlo_qodef_options()->getOptionValue('cf7_style_1_text_line_height');
		if($line_height !== ''){
			$styles['line-height'] = arlo_qodef_filter_px($line_height) . 'px';
			$styles['height'] = arlo_qodef_filter_px($line_height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_1_text_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_1_text_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_1_text_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_1_text_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_1_text_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_1_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_1_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		$border_width = arlo_qodef_options()->getOptionValue('cf7_style_1_border_width');
		if($border_width !== ''){
			$styles['border-width'] = arlo_qodef_filter_px($border_width) . 'px';
		}

		$border_radius = arlo_qodef_options()->getOptionValue('cf7_style_1_border_radius');
		if($border_radius !== ''){
			$styles['border-radius'] = arlo_qodef_filter_px($border_radius) . 'px';
		}

		$padding_top = arlo_qodef_options()->getOptionValue('cf7_style_1_padding_top');
		if($padding_top !== ''){
			$styles['padding-top'] = arlo_qodef_filter_px($padding_top) . 'px';
		}

		$padding_right = arlo_qodef_options()->getOptionValue('cf7_style_1_padding_right');
		if($padding_right !== ''){
			$styles['padding-right'] = arlo_qodef_filter_px($padding_right) . 'px';
		}

		$padding_bottom = arlo_qodef_options()->getOptionValue('cf7_style_1_padding_bottom');
		if($padding_bottom !== ''){
			$styles['padding-bottom'] = arlo_qodef_filter_px($padding_bottom) . 'px';
		}

		$padding_left = arlo_qodef_options()->getOptionValue('cf7_style_1_padding_left');
		if($padding_left !== ''){
			$styles['padding-left'] = arlo_qodef_filter_px($padding_left) . 'px';
		}

		$margin_top = arlo_qodef_options()->getOptionValue('cf7_style_1_margin_top');
		if($margin_top !== ''){
			$styles['margin-top'] = arlo_qodef_filter_px($margin_top) . 'px';
		}

		$margin_bottom = arlo_qodef_options()->getOptionValue('cf7_style_1_margin_bottom');
		if($margin_bottom !== ''){
			$styles['margin-bottom'] = arlo_qodef_filter_px($margin_bottom) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);

        if(arlo_qodef_options()->getOptionValue('cf7_style_1_textarea_height')) {
            $textarea_height = arlo_qodef_options()->getOptionValue('cf7_style_1_textarea_height');
            echo arlo_qodef_dynamic_css(
                '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea',
                array('height' => arlo_qodef_filter_px($textarea_height).'px')
            );
        }
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_text_styles_1');
}

if(!function_exists('arlo_qodef_contact_form7_focus_styles_1')) {
	/**
	 * Generates custom styles for Contact Form 7 elements focus
	 */
	function arlo_qodef_contact_form7_focus_styles_1() {
		$selector = array(
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus',
			'.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus',
			'.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus',
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_1_focus_text_color');
		if($color !== ''){
			$styles['color'] = $color;
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus::-webkit-input-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus:-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus:-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus:-moz-placeholder',
                    '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus:-moz-placeholder',
                    '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus:-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus:-moz-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus::-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus::-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus::-moz-placeholder',
                    '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus::-moz-placeholder',
                    '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus::-moz-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus::-moz-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-text:focus:-ms-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-number:focus:-ms-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-date:focus:-ms-input-placeholder',
                    '.cf7_custom_style_1 textarea.wpcf7-form-control.wpcf7-textarea:focus:-ms-input-placeholder',
                    '.cf7_custom_style_1 select.wpcf7-form-control.wpcf7-select:focus:-ms-input-placeholder',
                    '.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-quiz:focus:-ms-input-placeholder'
				),
				array('color' => $color)
			);
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_1_focus_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_focus_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_focus_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_1_focus_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_focus_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_focus_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_focus_styles_1');
}

if(!function_exists('arlo_qodef_contact_form7_label_styles_1')) {
	/**
	 * Generates custom styles for Contact Form 7 label
	 */
	function arlo_qodef_contact_form7_label_styles_1() {
		$selector = array('.cf7_custom_style_1 p');
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_1_label_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_1_label_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$line_height = arlo_qodef_options()->getOptionValue('cf7_style_1_label_line_height');
		if($line_height !== ''){
			$styles['line-height'] = arlo_qodef_filter_px($line_height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_1_label_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_1_label_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_1_label_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_1_label_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_1_label_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_label_styles_1');
}

if(!function_exists('arlo_qodef_contact_form7_button_styles_1')) {
	/**
	 * Generates custom styles for Contact Form 7 button
	 */
	function arlo_qodef_contact_form7_button_styles_1() {
		$selector = array(
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_1_button_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$height = arlo_qodef_options()->getOptionValue('cf7_style_1_button_height');
		if($height !== ''){
			$styles['height'] = arlo_qodef_filter_px($height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_1_button_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_1_button_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_1_button_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_1_button_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_1_button_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_button_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_button_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_button_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_button_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		$border_width = arlo_qodef_options()->getOptionValue('cf7_style_1_button_border_width');
		if($border_width !== ''){
			$styles['border-width'] = arlo_qodef_filter_px($border_width) . 'px';
		}

		$border_radius = arlo_qodef_options()->getOptionValue('cf7_style_1_button_border_radius');
		if($border_radius !== ''){
			$styles['border-radius'] = arlo_qodef_filter_px($border_radius) . 'px';
		}

		$padding_left_right = arlo_qodef_options()->getOptionValue('cf7_style_1_button_padding');
		if($padding_left_right !== ''){
			$styles['padding-left'] = arlo_qodef_filter_px($padding_left_right) . 'px';
			$styles['padding-right'] = arlo_qodef_filter_px($padding_left_right) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_button_styles_1');
}

if(!function_exists('arlo_qodef_contact_form7_button_hover_styles_1')) {
	/**
	 * Generates custom styles for Contact Form 7 button
	 */
	function arlo_qodef_contact_form7_button_hover_styles_1() {
		$selector = array(
			'.cf7_custom_style_1 input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_bckg_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_bckg_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_bckg_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_1_button_hover_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_button_hover_styles_1');
}

if(!function_exists('arlo_qodef_contact_form7_text_styles_2')) {
	/**
	 * Generates custom styles for Contact Form 7 elements
	 */
	function arlo_qodef_contact_form7_text_styles_2() {
		$selector = array(
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date',
			'.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea',
			'.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_2_text_color');
		if($color !== ''){
			$styles['color'] = $color;
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text::-webkit-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number::-webkit-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date::-webkit-input-placeholder',
                '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea::-webkit-input-placeholder',
                '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select::-webkit-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz::-webkit-input-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:-moz-placeholder',
                '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:-moz-placeholder',
                '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:-moz-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text::-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number::-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date::-moz-placeholder',
                '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea::-moz-placeholder',
                '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select::-moz-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz::-moz-placeholder'
            ),
			array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
            array(
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:-ms-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:-ms-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:-ms-input-placeholder',
                '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:-ms-input-placeholder',
                '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:-ms-input-placeholder',
                '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:-ms-input-placeholder'
            ),
			array('color' => $color)
			);
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_2_text_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$line_height = arlo_qodef_options()->getOptionValue('cf7_style_2_text_line_height');
		if($line_height !== ''){
			$styles['line-height'] = arlo_qodef_filter_px($line_height) . 'px';
			$styles['height'] = arlo_qodef_filter_px($line_height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_2_text_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_2_text_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_2_text_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_2_text_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_2_text_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_2_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_2_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		$border_width = arlo_qodef_options()->getOptionValue('cf7_style_2_border_width');
		if($border_width !== ''){
			$styles['border-width'] = arlo_qodef_filter_px($border_width) . 'px';
		}

		$border_radius = arlo_qodef_options()->getOptionValue('cf7_style_2_border_radius');
		if($border_radius !== ''){
			$styles['border-radius'] = arlo_qodef_filter_px($border_radius) . 'px';
		}

		$padding_top = arlo_qodef_options()->getOptionValue('cf7_style_2_padding_top');
		if($padding_top !== ''){
			$styles['padding-top'] = arlo_qodef_filter_px($padding_top) . 'px';
		}

		$padding_right = arlo_qodef_options()->getOptionValue('cf7_style_2_padding_right');
		if($padding_right !== ''){
			$styles['padding-right'] = arlo_qodef_filter_px($padding_right) . 'px';
		}

		$padding_bottom = arlo_qodef_options()->getOptionValue('cf7_style_2_padding_bottom');
		if($padding_bottom !== ''){
			$styles['padding-bottom'] = arlo_qodef_filter_px($padding_bottom) . 'px';
		}

		$padding_left = arlo_qodef_options()->getOptionValue('cf7_style_2_padding_left');
		if($padding_left !== ''){
			$styles['padding-left'] = arlo_qodef_filter_px($padding_left) . 'px';
		}

		$margin_top = arlo_qodef_options()->getOptionValue('cf7_style_2_margin_top');
		if($margin_top !== ''){
			$styles['margin-top'] = arlo_qodef_filter_px($margin_top) . 'px';
		}

		$margin_bottom = arlo_qodef_options()->getOptionValue('cf7_style_2_margin_bottom');
		if($margin_bottom !== ''){
			$styles['margin-bottom'] = arlo_qodef_filter_px($margin_bottom) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);

        if(arlo_qodef_options()->getOptionValue('cf7_style_2_textarea_height')) {
            $textarea_height = arlo_qodef_options()->getOptionValue('cf7_style_2_textarea_height');
            echo arlo_qodef_dynamic_css(
                '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea',
                array('height' => arlo_qodef_filter_px($textarea_height).'px')
            );
        }
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_text_styles_2');
}

if(!function_exists('arlo_qodef_contact_form7_focus_styles_2')) {
	/**
	 * Generates custom styles for Contact Form 7 elements focus
	 */
	function arlo_qodef_contact_form7_focus_styles_2() {
		$selector = array(
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus',
			'.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus',
			'.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus',
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_2_focus_text_color');
		if($color !== ''){
			$styles['color'] = $color;
			echo arlo_qodef_dynamic_css(
				array(
					'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus::-webkit-input-placeholder',
					'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus::-webkit-input-placeholder',
					'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus::-webkit-input-placeholder',
					'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus::-webkit-input-placeholder',
					'.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus::-webkit-input-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus::-webkit-input-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus:-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus:-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus:-moz-placeholder',
                    '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus:-moz-placeholder',
                    '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus:-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus:-moz-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus::-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus::-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus::-moz-placeholder',
                    '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus::-moz-placeholder',
                    '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus::-moz-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus::-moz-placeholder'
				),
				array('color' => $color)
			);
			echo arlo_qodef_dynamic_css(
				array(
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-text:focus:-ms-input-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-number:focus:-ms-input-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-date:focus:-ms-input-placeholder',
                    '.cf7_custom_style_2 textarea.wpcf7-form-control.wpcf7-textarea:focus:-ms-input-placeholder',
                    '.cf7_custom_style_2 select.wpcf7-form-control.wpcf7-select:focus:-ms-input-placeholder',
                    '.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-quiz:focus:-ms-input-placeholder'
				),
				array('color' => $color)
			);
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_2_focus_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_focus_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_focus_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_2_focus_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_focus_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_focus_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_focus_styles_2');
}

if(!function_exists('arlo_qodef_contact_form7_label_styles_2')) {
	/**
	 * Generates custom styles for Contact Form 7 label
	 */
	function arlo_qodef_contact_form7_label_styles_2() {
		$selector = array('.cf7_custom_style_2 p');
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_2_label_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_2_label_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$line_height = arlo_qodef_options()->getOptionValue('cf7_style_2_label_line_height');
		if($line_height !== ''){
			$styles['line-height'] = arlo_qodef_filter_px($line_height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_2_label_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_2_label_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_2_label_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_2_label_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_2_label_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_label_styles_2');
}

if(!function_exists('arlo_qodef_contact_form7_button_styles_2')) {
	/**
	 * Generates custom styles for Contact Form 7 button
	 */
	function arlo_qodef_contact_form7_button_styles_2() {
		$selector = array(
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$font_size = arlo_qodef_options()->getOptionValue('cf7_style_2_button_font_size');
		if($font_size !== ''){
			$styles['font-size'] = arlo_qodef_filter_px($font_size) . 'px';
		}

		$height = arlo_qodef_options()->getOptionValue('cf7_style_2_button_height');
		if($height !== ''){
			$styles['height'] = arlo_qodef_filter_px($height) . 'px';
		}

		$font_family = arlo_qodef_options()->getOptionValue('cf7_style_2_button_font_family');
		if(arlo_qodef_is_font_option_valid($font_family)) {
			$styles['font-family'] = arlo_qodef_get_font_option_val($font_family);
		}

		$font_style = arlo_qodef_options()->getOptionValue('cf7_style_2_button_font_style');
		if(!empty($font_style)){
			$styles['font-style'] = $font_style;
		}

		$font_weight = arlo_qodef_options()->getOptionValue('cf7_style_2_button_font_weight');
		if(!empty($font_weight)){
			$styles['font-weight'] = $font_weight;
		}

		$text_transform = arlo_qodef_options()->getOptionValue('cf7_style_2_button_text_transform');
		if(!empty($text_transform)){
			$styles['text-transform'] = $text_transform;
		}

		$letter_spacing = arlo_qodef_options()->getOptionValue('cf7_style_2_button_letter_spacing');
		if($letter_spacing !== ''){
			$styles['letter-spacing'] = arlo_qodef_filter_px($letter_spacing) . 'px';
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_background_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_button_background_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_button_background_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_button_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_button_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		$border_width = arlo_qodef_options()->getOptionValue('cf7_style_2_button_border_width');
		if($border_width !== ''){
			$styles['border-width'] = arlo_qodef_filter_px($border_width) . 'px';
		}

		$border_radius = arlo_qodef_options()->getOptionValue('cf7_style_2_button_border_radius');
		if($border_radius !== ''){
			$styles['border-radius'] = arlo_qodef_filter_px($border_radius) . 'px';
		}

		$padding_left_right = arlo_qodef_options()->getOptionValue('cf7_style_2_button_padding');
		if($padding_left_right !== ''){
			$styles['padding-left'] = arlo_qodef_filter_px($padding_left_right) . 'px';
			$styles['padding-right'] = arlo_qodef_filter_px($padding_left_right) . 'px';
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_button_styles_2');
}

if(!function_exists('arlo_qodef_contact_form7_button_hover_styles_2')) {
	/**
	 * Generates custom styles for Contact Form 7 button
	 */
	function arlo_qodef_contact_form7_button_hover_styles_2() {
		$selector = array(
			'.cf7_custom_style_2 input.wpcf7-form-control.wpcf7-submit:not([disabled]):hover'
		);
		$styles = array();

		$color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_color');
		if($color !== ''){
			$styles['color'] = $color;
		}

		$background_color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_bckg_color');
		$background_opacity = 1;
		if($background_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_bckg_transparency') !== ''){
				$background_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_bckg_transparency');
			}
			$styles['background-color'] = arlo_qodef_rgba_color($background_color,$background_opacity);
		}

		$border_color = arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_border_color');
		$border_opacity = 1;
		if($border_color !== ''){
			if(arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_border_transparency') !== ''){
				$border_opacity = arlo_qodef_options()->getOptionValue('cf7_style_2_button_hover_border_transparency');
			}
			$styles['border-color'] = arlo_qodef_rgba_color($border_color,$border_opacity);
		}

		echo arlo_qodef_dynamic_css($selector, $styles);
	}

	add_action('arlo_qodef_style_dynamic', 'arlo_qodef_contact_form7_button_hover_styles_2');
}