<?php

/*** Video Post Format ***/

$video_post_format_meta_box = arlo_qodef_add_meta_box(
	array(
		'scope' =>	array('post'),
		'title' => 'Video Post Format',
		'name' 	=> 'post_format_video_meta'
	)
);

arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_video_type_meta',
		'type'        => 'select',
		'label'       => 'Video Type',
		'description' => 'Choose video type',
		'parent'      => $video_post_format_meta_box,
		'default_value' => 'social_networks',
		'options'     => array(
			'social_networks' => 'Youtube or Vimeo',
			'self' => 'Self Hosted'
		),
		'args' => array(
		'dependence' => true,
		'hide' => array(
			'social_networks' => '#qodef_qodef_video_self_hosted_container',
			'self' => '#qodef_qodef_video_embedded_container'
		),
		'show' => array(
			'social_networks' => '#qodef_qodef_video_embedded_container',
			'self' => '#qodef_qodef_video_self_hosted_container')
	)
	)
);

$qodef_video_embedded_container = arlo_qodef_add_admin_container(
	array(
		'parent' => $video_post_format_meta_box,
		'name' => 'qodef_video_embedded_container',
		'hidden_property' => 'qodef_video_type_meta',
		'hidden_value' => 'self'
	)
);

$qodef_video_self_hosted_container = arlo_qodef_add_admin_container(
	array(
		'parent' => $video_post_format_meta_box,
		'name' => 'qodef_video_self_hosted_container',
		'hidden_property' => 'qodef_video_type_meta',
		'hidden_value' => 'social_networks'
	)
);



arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_post_video_link_meta',
		'type'        => 'text',
		'label'       => 'Video URL',
		'description' => 'Enter Video URL',
		'parent'      => $qodef_video_embedded_container,

	)
);


arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_post_video_image_meta',
		'type'        => 'image',
		'label'       => 'Video Image',
		'description' => 'Upload video image',
		'parent'      => $qodef_video_self_hosted_container,

	)
);

arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_post_video_webm_link_meta',
		'type'        => 'text',
		'label'       => 'Video WEBM',
		'description' => 'Enter video URL for WEBM format',
		'parent'      => $qodef_video_self_hosted_container,

	)
);

arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_post_video_mp4_link_meta',
		'type'        => 'text',
		'label'       => 'Video MP4',
		'description' => 'Enter video URL for MP4 format',
		'parent'      => $qodef_video_self_hosted_container,

	)
);

arlo_qodef_add_meta_box_field(
	array(
		'name'        => 'qodef_post_video_ogv_link_meta',
		'type'        => 'text',
		'label'       => 'Video OGV',
		'description' => 'Enter video URL for OGV format',
		'parent'      => $qodef_video_self_hosted_container,

	)
);