<?php
if(!function_exists('arlo_qodef_design_styles')) {
    /**
     * Generates general custom styles
     */
    function arlo_qodef_design_styles() {

        $preload_background_styles = array();

        if(arlo_qodef_options()->getOptionValue('preload_pattern_image') !== ""){
            $preload_background_styles['background-image'] = 'url('.arlo_qodef_options()->getOptionValue('preload_pattern_image').') !important';
        }else{
            $preload_background_styles['background-image'] = 'url('.esc_url(QODE_ASSETS_ROOT."/img/preload_pattern.png").') !important';
        }

        echo arlo_qodef_dynamic_css('.qodef-preload-background', $preload_background_styles);

		if (arlo_qodef_options()->getOptionValue('google_fonts')){
			$font_family = arlo_qodef_options()->getOptionValue('google_fonts');
			if(arlo_qodef_is_font_option_valid($font_family)) {
				echo arlo_qodef_dynamic_css('body', array('font-family' => arlo_qodef_get_font_option_val($font_family)));
			}
		}

        if(arlo_qodef_options()->getOptionValue('first_color') !== "") {
            $color_selector = array(
                'h1 a:hover',
                'h2 a:hover',
                'h3 a:hover',
                'h4 a:hover',
                'h5 a:hover',
                'h6 a:hover',
                'a',
                'p a',
                '.qodef-drop-down .wide .second .inner ul li.sub .flexslider ul li a:hover',
                '.qodef-drop-down .wide .second ul li .flexslider ul li a:hover',
                '.qodef-drop-down .wide .second .inner ul li.sub .flexslider.widget_flexslider .menu_recent_post_text a:hover',
                '.qodef-mobile-header .qodef-mobile-nav a:hover, .qodef-mobile-header .qodef-mobile-nav h4:hover',
                '.qodef-mobile-header .qodef-mobile-menu-opener a:hover',
                'nav.qodef-fullscreen-menu ul li a:hover',
                'nav.qodef-fullscreen-menu ul li ul li a',
                '.qodef-search-slide-header-bottom .qodef-search-submit:hover',
                '.qodef-search-cover .qodef-search-close a:hover',
                '.qodef-ordered-list ol > li:before',
                '.qodef-icon-list-item .qodef-icon-list-icon-holder .qodef-icon-list-icon-holder-inner i',
                '.qodef-icon-list-item .qodef-icon-list-icon-holder .qodef-icon-list-icon-holder-inner .font_elegant',
                '.qodef-price-table .qodef-price-table-inner ul li.qodef-table-prices .qodef-value',
                '.qodef-price-table .qodef-price-table-inner ul li.qodef-table-prices .qodef-price',
                '.qodef-price-table.qodef-active .qodef-active-text',
                '.qodef-btn.qodef-btn-outline',
                '#submit_comment:hover',
                '.post-password-form input[type="submit"]:hover',
                'input.wpcf7-form-control.wpcf7-submit:hover',
                '.qodef-progress-bar .qodef-progress-title-holder',
                '.qodef-counter-holder .qodef-counter',
                '.qodef-counter-holder .qodef-counter-icon',
				'.qodef-icon-list-item .qodef-icon-list-icon-holder-inner i',
				'.qodef-icon-list-item .qodef-icon-list-icon-holder-inner .font_elegant',
				'.qodef-ordered-list ol>li:before',
				'.qodef-portfolio-filter-holder .qodef-portfolio-filter-holder-inner ul li.active span',
				'.qodef-portfolio-filter-holder .qodef-portfolio-filter-holder-inner ul li.current span',
				'.qodef-portfolio-list-holder article .qodef-item-icons-holder a',
				'.qodef-portfolio-list-holder.qodef-ptf-standard article .qodef-item-icons-holder a:hover',
				'.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.owl-carousel .owl-buttons .qodef-prev-icon i',
				'.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.owl-carousel .owl-buttons .qodef-next-icon i',
                '.qodef-testimonials.light .qodef-testimonial-text-bottom .qodef-testimonial-author .qodef-testimonial-author-text',
                '.qodef-process-holder .qodef-process-item:hover .qodef-process-number',
                'body div.pp_default a.pp_next:hover',
                'body div.pp_default a.pp_previous:hover',
                '.qodef-tabs .qodef-tabs-nav li.ui-state-active a',
                '.qodef-tabs .qodef-tabs-nav li.ui-state-hover a',
                '.qodef-blog-holder article.format-audio .mejs-controls .mejs-mute button:after',
                '.qodef-blog-holder article.format-audio .mejs-controls .mejs-unmute button:after',
                '.qodef-blog-holder.qodef-blog-type-masonry article.format-audio .mejs-controls .mejs-mute button:after',
                '.qodef-blog-holder.qodef-blog-type-masonry article.format-audio .mejs-controls .mejs-unmute button:after',
                '.owl-carousel .owl-nav .qodef-prev-icon:hover i',
                '.owl-carousel .owl-nav .qodef-next-icon:hover i',
                '.qodef-twitter-widget li .qodef-social-twitter',
                '.qodef-blog-holder article .qodef-post-date-inner .qodef-post-date-day',
                '.qodef-blog-holder article .qodef-post-date-inner .qodef-post-date-month',
                '.qodef-sidebar .widget.widget_price_filter .price_slider_amount .button:hover',
                '.qodef-sidebar .widget.widget_recently_viewed_products .qodef-product-list-widget-info-wrapper a',
                '.woocommerce-pagination .page-numbers li > a',
                '.woocommerce-pagination .page-numbers li > span',
                '.qodef-blog-holder.qodef-blog-single .qodef-post-info-bottom .qodef-single-tags-holder .qodef-single-tags-title',
                '.qodef-comment-holder .qodef-comment-text .replay',
                '.qodef-comment-holder .qodef-comment-text .comment-reply-link',
                '.qodef-comment-holder .qodef-comment-text .comment-edit-link',
                '.qodef-comment-holder .qodef-comment-text .qodef-comment-name',
                '.qodef-comment-form .comment-respond .comment-reply-title',
                '.qodef-comment-holder .qodef-comment-number h6',
                '.qodef-accordion-holder .qodef-title-holder',
                '.qodef-accordion-holder .qodef-title-holder.ui-state-active',
                '.qodef-accordion-holder .qodef-title-holder.ui-state-hover',
                '.qodef-woocommerce-page .qodef-quantity-buttons .qodef-quantity-input',
                '.qodef-pie-chart-holder .qodef-to-counter',
                '.qodef-pie-chart-with-icon-holder .qodef-percentage-with-icon i',
                '.qodef-pie-chart-with-icon-holder .qodef-percentage-with-icon span',
                '.qodef-single-product-summary .entry-summary .qodef-woocommerce-single-share .qodef-social-share-holder a:hover',
                '.qodef-woocommerce-page .shop_table.cart tbody tr td.product-remove .remove_from_wishlist:before',
                '.qodef-woocommerce-page .shop_table.cart tbody tr td.product-remove .remove:before',
                '.woocommerce .shop_table.cart tbody tr td.product-remove .remove_from_wishlist:before',
                '.woocommerce .shop_table.cart tbody tr td.product-remove .remove:before',
                '.qodef-woocommerce-page .shop_table.cart tbody tr td.product-subtotal span',
                '.woocommerce .shop_table.cart tbody tr td.product-subtotal span',
                '.qodef-woocommerce-page .woocommerce-checkout .woocommerce-checkout-payment .wc_payment_methods label:after',
                '.woocommerce .woocommerce-checkout .woocommerce-checkout-payment .wc_payment_methods label:after',
                '.qodef-woocommerce-page .qodef-cart-totals .cart_totals #shipping_method label:after',
                '.woocommerce .qodef-cart-totals .cart_totals #shipping_method label:after',
                '.qodef-woocommerce-page .woocommerce-checkout label[for="ship-to-different-address-checkbox"]:after',
                '.qodef-woocommerce-page .woocommerce-checkout label[for="createaccount"]:after',
                '.woocommerce .woocommerce-checkout label[for="ship-to-different-address-checkbox"]:after',
                '.woocommerce .woocommerce-checkout label[for="createaccount"]:after',
                '.qodef-process-holder .qodef-process-item.active .qodef-process-number',
                '.qodef-portfolio-filter-holder .qodef-portfolio-filter-holder-inner ul li:hover span',
                '.qodef-portfolio-single-holder .qodef-portfolio-single-nav span:hover',
                '.qodef-portfolio-single-holder .qodef-portfolio-single-nav span:hover',
                '.qodef-portfolio-single-holder .qodef-portfolio-social .qodef-social-share-holder.qodef-list a:hover',
                '.qodef-blog-holder article .qodef-post-info > div a:hover',
                '.qodef-countdown',
                '.qodef-mobile-header .qodef-mobile-nav li.qodef-active-item a',
                '.qodef-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li.is-active a',
                '.qodef-woocommerce-page.woocommerce-account .woocommerce-MyAccount-navigation ul li a:hover'
            );

            $color_important_selector = array(

            );

            $background_color_selector = array(
                '.qodef-title',
                '.qodef-fullscreen-menu-opener:hover .qodef-line',
                '.qodef-fullscreen-menu-opener.opened:hover .qodef-line:after',
                '.qodef-fullscreen-menu-opener.opened:hover .qodef-line:before',
                '.qodef-icon-shortcode.circle, .qodef-icon-shortcode.square',
                '.qodef-pie-chart-doughnut-holder .qodef-pie-legend ul li .qodef-pie-color-holder',
                '.qodef-pie-chart-pie-holder .qodef-pie-legend ul li .qodef-pie-color-holder',
                '.qodef-btn.qodef-btn-solid',
                '#submit_comment',
                '.post-password-form input[type="submit"]',
                'input.wpcf7-form-control.wpcf7-submit',
				'#qodef-back-to-top > span',
                '.qodef-video-button-play .qodef-video-button-wrapper:hover',
                '.qodef-progress-bar .qodef-progress-title-holder .qodef-progress-number-wrapper .qodef-progress-number',
                '.qodef-price-table .qodef-price-table-inner ul li.qodef-table-title',
				'.qodef-accordion-holder .qodef-title-holder.ui-state-active .qodef-accordion-mark',
				'.qodef-accordion-holder .qodef-title-holder.ui-state-hover .qodef-accordion-mark',
				'.qodef-portfolio-list-holder.qodef-ptf-standard article .qodef-item-icons-holder a',
                '.qodef-underline-icon-box-holder .qodef-underline-icon-box-line',
                '.qodef-team .qodef-team-social-holder',
                '.qodef-tabs.qodef-dark-tab .qodef-tabs-nav li.ui-state-active a',
                '.qodef-tabs.qodef-dark-tab .qodef-tabs-nav li.ui-state-hover a',
                '.qodef-blog-holder article.format-audio .mejs-container .mejs-controls .mejs-button.mejs-playpause-button',
                '.qodef-blog-holder article.format-audio .mejs-controls .mejs-time-rail .mejs-time-current',
                '.qodef-blog-holder article.format-audio .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current',
                '.qodef-pagination li a:hover',
                '.qodef-pagination li.active span',
                '.woocommerce .added_to_cart',
                '.qodef-woocommerce-page .added_to_cart',
                '.woocommerce .product .qodef-onsale',
                '.woocommerce .product .qodef-out-of-stock-button',
                '.qodef-woocommerce-page .product .qodef-onsale',
                '.qodef-woocommerce-page .product .qodef-out-of-stock-button',
                '.qodef-sidebar .widget .woocommerce-product-search input[type="submit"]',
                '.qodef-sidebar .widget #searchform input[type="submit"]',
                '.qodef-sidebar .widget.widget_price_filter .ui-slider-handle',
                '.qodef-sidebar .widget.widget_price_filter .price_slider_amount .button',
                '.woocommerce-pagination .page-numbers li span.current',
                '.woocommerce-pagination .page-numbers li a:hover',
                '.qodef-blog-holder.qodef-blog-single .qodef-post-info-bottom .qodef-single-tags-holder .qodef-tags a',
                '.qodef-woocommerce-page .select2-results .select2-highlighted',
                '.woocommerce input[type="submit"]',
                '.qodef-woocommerce-page .qodef-cart-totals .cart_totals .shipping-calculator-form .qodef-btn.qodef-btn-solid',
                '.qodef-woocommerce-page .qodef-cart-totals .cart_totals .shipping-calculator-button',
                '.woocommerce .qodef-cart-totals .cart_totals .shipping-calculator-form .qodef-btn.qodef-btn-solid',
                '.woocommerce .qodef-cart-totals .cart_totals .shipping-calculator-button',
                '.qodef-woocommerce-page .woocommerce-message a',
                '.qodef-woocommerce-page .woocommerce-info a',
                '.qodef-woocommerce-page .woocommerce-error a',
                '.woocommerce-page .woocommerce-message a',
                '.woocommerce-page .woocommerce-info a',
                '.woocommerce-page .woocommerce-error a',
                '.woocommerce .woocommerce-message a',
                '.woocommerce .woocommerce-info a',
                '.woocommerce .woocommerce-error a',
                '.qodef-portfolio-list-holder-outer.qodef-ptf-image-shift article .qodef-item-text-holder',
                '.qodef-portfolio-list-holder-outer.qodef-ptf-masonry article .qodef-item-text-holder',
                '.qodef-woocommerce-page .qodef-quantity-buttons .qodef-quantity-minus:hover, .qodef-woocommerce-page .qodef-quantity-buttons .qodef-quantity-plus:hover',
                '.qodef-sidebar .widget.widget_tag_cloud a',
                '.qodef-blog-holder article.sticky .qodef-post-date-inner .qodef-post-date-month',
                '.qodef-drop-down .second .inner ul > li > a:after'
            );

            $background_color_important_selector = array(

            );

            $border_color_selector = array(
                '.qodef-drop-down .second',
                '.qodef-progress-bar .qodef-progress-number-wrapper.qodef-floating .qodef-down-arrow',
                '.qodef-btn.qodef-btn-solid',
                '.qodef-btn.qodef-btn-outline',
                '#submit_comment',
                '.post-password-form input[type="submit"]',
                'input.wpcf7-form-control.wpcf7-submit',
				'.qodef-accordion-holder .qodef-title-holder.ui-state-active .qodef-accordion-mark',
				'.qodef-accordion-holder .qodef-title-holder.ui-state-hover .qodef-accordion-mark',
				'.qodef-portfolio-list-holder article .qodef-item-icons-holder a',
				'.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.owl-carousel .owl-buttons .qodef-prev-icon',
				'.qodef-portfolio-slider-holder .qodef-portfolio-list-holder.owl-carousel .owl-buttons .qodef-next-icon',
                '.qodef-progress-bar .qodef-progress-title-holder .qodef-progress-number-wrapper .qodef-down-arrow',
                '.woocommerce .added_to_cart',
                '.qodef-woocommerce-page .added_to_cart',
                '.qodef-sidebar .widget.widget_price_filter .price_slider_amount .button:hover',
                '.woocommerce input[type="submit"]',
                '.qodef-woocommerce-page .qodef-cart-totals .cart_totals .shipping-calculator-form .qodef-btn.qodef-btn-solid',
                '.qodef-woocommerce-page .qodef-cart-totals .cart_totals .shipping-calculator-button',
                '.woocommerce .qodef-cart-totals .cart_totals .shipping-calculator-form .qodef-btn.qodef-btn-solid',
                '.woocommerce .qodef-cart-totals .cart_totals .shipping-calculator-button',
                '.qodef-woocommerce-page .woocommerce-message a',
                '.qodef-woocommerce-page .woocommerce-info a',
                '.qodef-woocommerce-page .woocommerce-error a',
                '.woocommerce-page .woocommerce-message a',
                '.woocommerce-page .woocommerce-info a',
                '.woocommerce-page .woocommerce-error a',
                '.woocommerce .woocommerce-message a',
                '.woocommerce .woocommerce-info a',
                '.woocommerce .woocommerce-error a'
            );

            $border_color_important_selector = array(
                '.qodef-btn.qodef-btn-outline:not(.qodef-btn-custom-border-hover):hover'
            );

            echo arlo_qodef_dynamic_css($color_selector, array('color' => arlo_qodef_options()->getOptionValue('first_color')));
            echo arlo_qodef_dynamic_css($color_important_selector, array('color' => arlo_qodef_options()->getOptionValue('first_color').'!important'));
            echo arlo_qodef_dynamic_css('::selection', array('background' => arlo_qodef_options()->getOptionValue('first_color')));
            echo arlo_qodef_dynamic_css('::-moz-selection', array('background' => arlo_qodef_options()->getOptionValue('first_color')));
            echo arlo_qodef_dynamic_css($background_color_selector, array('background-color' => arlo_qodef_options()->getOptionValue('first_color')));
            echo arlo_qodef_dynamic_css($background_color_important_selector, array('background-color' => arlo_qodef_options()->getOptionValue('first_color').'!important'));
            echo arlo_qodef_dynamic_css($border_color_selector, array('border-color' => arlo_qodef_options()->getOptionValue('first_color')));
            echo arlo_qodef_dynamic_css($border_color_important_selector, array('border-color' => arlo_qodef_options()->getOptionValue('first_color').'!important'));
        }

		if (arlo_qodef_options()->getOptionValue('page_background_color')) {
			$background_color_selector = array(
                '.qodef-content .qodef-content-inner > .qodef-container',
                '.qodef-content .qodef-content-inner > .qodef-full-width'
			);
			echo arlo_qodef_dynamic_css($background_color_selector, array('background-color' => arlo_qodef_options()->getOptionValue('page_background_color')));
		}

		if (arlo_qodef_options()->getOptionValue('selection_color')) {
			echo arlo_qodef_dynamic_css('::selection', array('background' => arlo_qodef_options()->getOptionValue('selection_color')));
			echo arlo_qodef_dynamic_css('::-moz-selection', array('background' => arlo_qodef_options()->getOptionValue('selection_color')));
		}

		$boxed_background_style = array();
		if (arlo_qodef_options()->getOptionValue('page_background_color_in_box')) {
			$boxed_background_style['background-color'] = arlo_qodef_options()->getOptionValue('page_background_color_in_box');
		}

		if (arlo_qodef_options()->getOptionValue('boxed_background_image')) {
			$boxed_background_style['background-image'] = 'url('.esc_url(arlo_qodef_options()->getOptionValue('boxed_background_image')).')';
			$boxed_background_style['background-position'] = 'center 0px';
			$boxed_background_style['background-repeat'] = 'no-repeat';
		}

		if (arlo_qodef_options()->getOptionValue('boxed_pattern_background_image')) {
			$boxed_background_style['background-image'] = 'url('.esc_url(arlo_qodef_options()->getOptionValue('boxed_pattern_background_image')).')';
			$boxed_background_style['background-position'] = '0px 0px';
			$boxed_background_style['background-repeat'] = 'repeat';
		}

		if (arlo_qodef_options()->getOptionValue('boxed_background_image_attachment')) {
			$boxed_background_style['background-attachment'] = (arlo_qodef_options()->getOptionValue('boxed_background_image_attachment'));
		}

		echo arlo_qodef_dynamic_css('.qodef-boxed .qodef-wrapper', $boxed_background_style);
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_design_styles');
}

if (!function_exists('arlo_qodef_h1_styles')) {

    function arlo_qodef_h1_styles() {

        $h1_styles = array();

        if(arlo_qodef_options()->getOptionValue('h1_color') !== '') {
            $h1_styles['color'] = arlo_qodef_options()->getOptionValue('h1_color');
        }
        if(arlo_qodef_options()->getOptionValue('h1_google_fonts') !== '-1') {
            $h1_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h1_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h1_fontsize') !== '') {
            $h1_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h1_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h1_lineheight') !== '') {
            $h1_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h1_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h1_texttransform') !== '') {
            $h1_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h1_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h1_fontstyle') !== '') {
            $h1_styles['font-style'] = arlo_qodef_options()->getOptionValue('h1_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h1_fontweight') !== '') {
            $h1_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h1_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h1_letterspacing') !== '') {
            $h1_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h1_letterspacing')).'px';
        }

        $h1_selector = array(
            'h1'
        );

        if (!empty($h1_styles)) {
            echo arlo_qodef_dynamic_css($h1_selector, $h1_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h1_styles');
}

if (!function_exists('arlo_qodef_h2_styles')) {

    function arlo_qodef_h2_styles() {

        $h2_styles = array();

        if(arlo_qodef_options()->getOptionValue('h2_color') !== '') {
            $h2_styles['color'] = arlo_qodef_options()->getOptionValue('h2_color');
        }
        if(arlo_qodef_options()->getOptionValue('h2_google_fonts') !== '-1') {
            $h2_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h2_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h2_fontsize') !== '') {
            $h2_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h2_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h2_lineheight') !== '') {
            $h2_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h2_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h2_texttransform') !== '') {
            $h2_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h2_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h2_fontstyle') !== '') {
            $h2_styles['font-style'] = arlo_qodef_options()->getOptionValue('h2_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h2_fontweight') !== '') {
            $h2_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h2_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h2_letterspacing') !== '') {
            $h2_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h2_letterspacing')).'px';
        }

        $h2_selector = array(
            'h2'
        );

        if (!empty($h2_styles)) {
            echo arlo_qodef_dynamic_css($h2_selector, $h2_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h2_styles');
}

if (!function_exists('arlo_qodef_h3_styles')) {

    function arlo_qodef_h3_styles() {

        $h3_styles = array();

        if(arlo_qodef_options()->getOptionValue('h3_color') !== '') {
            $h3_styles['color'] = arlo_qodef_options()->getOptionValue('h3_color');
        }
        if(arlo_qodef_options()->getOptionValue('h3_google_fonts') !== '-1') {
            $h3_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h3_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h3_fontsize') !== '') {
            $h3_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h3_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h3_lineheight') !== '') {
            $h3_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h3_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h3_texttransform') !== '') {
            $h3_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h3_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h3_fontstyle') !== '') {
            $h3_styles['font-style'] = arlo_qodef_options()->getOptionValue('h3_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h3_fontweight') !== '') {
            $h3_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h3_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h3_letterspacing') !== '') {
            $h3_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h3_letterspacing')).'px';
        }

        $h3_selector = array(
            'h3'
        );

        if (!empty($h3_styles)) {
            echo arlo_qodef_dynamic_css($h3_selector, $h3_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h3_styles');
}

if (!function_exists('arlo_qodef_h4_styles')) {

    function arlo_qodef_h4_styles() {

        $h4_styles = array();

        if(arlo_qodef_options()->getOptionValue('h4_color') !== '') {
            $h4_styles['color'] = arlo_qodef_options()->getOptionValue('h4_color');
        }
        if(arlo_qodef_options()->getOptionValue('h4_google_fonts') !== '-1') {
            $h4_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h4_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h4_fontsize') !== '') {
            $h4_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h4_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h4_lineheight') !== '') {
            $h4_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h4_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h4_texttransform') !== '') {
            $h4_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h4_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h4_fontstyle') !== '') {
            $h4_styles['font-style'] = arlo_qodef_options()->getOptionValue('h4_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h4_fontweight') !== '') {
            $h4_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h4_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h4_letterspacing') !== '') {
            $h4_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h4_letterspacing')).'px';
        }

        $h4_selector = array(
            'h4'
        );

        if (!empty($h4_styles)) {
            echo arlo_qodef_dynamic_css($h4_selector, $h4_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h4_styles');
}

if (!function_exists('arlo_qodef_h5_styles')) {

    function arlo_qodef_h5_styles() {

        $h5_styles = array();

        if(arlo_qodef_options()->getOptionValue('h5_color') !== '') {
            $h5_styles['color'] = arlo_qodef_options()->getOptionValue('h5_color');
        }
        if(arlo_qodef_options()->getOptionValue('h5_google_fonts') !== '-1') {
            $h5_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h5_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h5_fontsize') !== '') {
            $h5_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h5_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h5_lineheight') !== '') {
            $h5_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h5_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h5_texttransform') !== '') {
            $h5_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h5_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h5_fontstyle') !== '') {
            $h5_styles['font-style'] = arlo_qodef_options()->getOptionValue('h5_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h5_fontweight') !== '') {
            $h5_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h5_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h5_letterspacing') !== '') {
            $h5_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h5_letterspacing')).'px';
        }

        $h5_selector = array(
            'h5'
        );

        if (!empty($h5_styles)) {
            echo arlo_qodef_dynamic_css($h5_selector, $h5_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h5_styles');
}

if (!function_exists('arlo_qodef_h6_styles')) {

    function arlo_qodef_h6_styles() {

        $h6_styles = array();

        if(arlo_qodef_options()->getOptionValue('h6_color') !== '') {
            $h6_styles['color'] = arlo_qodef_options()->getOptionValue('h6_color');
        }
        if(arlo_qodef_options()->getOptionValue('h6_google_fonts') !== '-1') {
            $h6_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('h6_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('h6_fontsize') !== '') {
            $h6_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h6_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h6_lineheight') !== '') {
            $h6_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h6_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('h6_texttransform') !== '') {
            $h6_styles['text-transform'] = arlo_qodef_options()->getOptionValue('h6_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('h6_fontstyle') !== '') {
            $h6_styles['font-style'] = arlo_qodef_options()->getOptionValue('h6_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('h6_fontweight') !== '') {
            $h6_styles['font-weight'] = arlo_qodef_options()->getOptionValue('h6_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('h6_letterspacing') !== '') {
            $h6_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('h6_letterspacing')).'px';
        }

        $h6_selector = array(
            'h6'
        );

        if (!empty($h6_styles)) {
            echo arlo_qodef_dynamic_css($h6_selector, $h6_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_h6_styles');
}

if (!function_exists('arlo_qodef_text_styles')) {

    function arlo_qodef_text_styles() {

        $text_styles = array();

        if(arlo_qodef_options()->getOptionValue('text_color') !== '') {
            $text_styles['color'] = arlo_qodef_options()->getOptionValue('text_color');
        }
        if(arlo_qodef_options()->getOptionValue('text_google_fonts') !== '-1') {
            $text_styles['font-family'] = arlo_qodef_get_formatted_font_family(arlo_qodef_options()->getOptionValue('text_google_fonts'));
        }
        if(arlo_qodef_options()->getOptionValue('text_fontsize') !== '') {
            $text_styles['font-size'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('text_fontsize')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('text_lineheight') !== '') {
            $text_styles['line-height'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('text_lineheight')).'px';
        }
        if(arlo_qodef_options()->getOptionValue('text_texttransform') !== '') {
            $text_styles['text-transform'] = arlo_qodef_options()->getOptionValue('text_texttransform');
        }
        if(arlo_qodef_options()->getOptionValue('text_fontstyle') !== '') {
            $text_styles['font-style'] = arlo_qodef_options()->getOptionValue('text_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('text_fontweight') !== '') {
            $text_styles['font-weight'] = arlo_qodef_options()->getOptionValue('text_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('text_letterspacing') !== '') {
            $text_styles['letter-spacing'] = arlo_qodef_filter_px(arlo_qodef_options()->getOptionValue('text_letterspacing')).'px';
        }

        $text_selector = array(
            'p'
        );

        if (!empty($text_styles)) {
            echo arlo_qodef_dynamic_css($text_selector, $text_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_text_styles');
}

if (!function_exists('arlo_qodef_link_styles')) {

    function arlo_qodef_link_styles() {

        $link_styles = array();

        if(arlo_qodef_options()->getOptionValue('link_color') !== '') {
            $link_styles['color'] = arlo_qodef_options()->getOptionValue('link_color');
        }
        if(arlo_qodef_options()->getOptionValue('link_fontstyle') !== '') {
            $link_styles['font-style'] = arlo_qodef_options()->getOptionValue('link_fontstyle');
        }
        if(arlo_qodef_options()->getOptionValue('link_fontweight') !== '') {
            $link_styles['font-weight'] = arlo_qodef_options()->getOptionValue('link_fontweight');
        }
        if(arlo_qodef_options()->getOptionValue('link_fontdecoration') !== '') {
            $link_styles['text-decoration'] = arlo_qodef_options()->getOptionValue('link_fontdecoration');
        }

        $link_selector = array(
            'a',
            'p a'
        );

        if (!empty($link_styles)) {
            echo arlo_qodef_dynamic_css($link_selector, $link_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_link_styles');
}

if (!function_exists('arlo_qodef_link_hover_styles')) {

    function arlo_qodef_link_hover_styles() {

        $link_hover_styles = array();

        if(arlo_qodef_options()->getOptionValue('link_hovercolor') !== '') {
            $link_hover_styles['color'] = arlo_qodef_options()->getOptionValue('link_hovercolor');
        }
        if(arlo_qodef_options()->getOptionValue('link_hover_fontdecoration') !== '') {
            $link_hover_styles['text-decoration'] = arlo_qodef_options()->getOptionValue('link_hover_fontdecoration');
        }

        $link_hover_selector = array(
            'a:hover',
            'p a:hover'
        );

        if (!empty($link_hover_styles)) {
            echo arlo_qodef_dynamic_css($link_hover_selector, $link_hover_styles);
        }

        $link_heading_hover_styles = array();

        if(arlo_qodef_options()->getOptionValue('link_hovercolor') !== '') {
            $link_heading_hover_styles['color'] = arlo_qodef_options()->getOptionValue('link_hovercolor');
        }

        $link_heading_hover_selector = array(
            'h1 a:hover',
            'h2 a:hover',
            'h3 a:hover',
            'h4 a:hover',
            'h5 a:hover',
            'h6 a:hover'
        );

        if (!empty($link_heading_hover_styles)) {
            echo arlo_qodef_dynamic_css($link_heading_hover_selector, $link_heading_hover_styles);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_link_hover_styles');
}

if (!function_exists('arlo_qodef_smooth_page_transition_styles')) {

    function arlo_qodef_smooth_page_transition_styles() {
        
        $loader_style = array();

        if(arlo_qodef_options()->getOptionValue('smooth_pt_bgnd_color') !== '') {
            $loader_style['background-color'] = arlo_qodef_options()->getOptionValue('smooth_pt_bgnd_color');
        }

        $loader_selector = array('.qodef-smooth-transition-loader');

        if (!empty($loader_style)) {
            echo arlo_qodef_dynamic_css($loader_selector, $loader_style);
        }

        $spinner_style = array();

        if(arlo_qodef_options()->getOptionValue('smooth_pt_spinner_color') !== '') {
            $spinner_style['background-color'] = arlo_qodef_options()->getOptionValue('smooth_pt_spinner_color');
        }

        $spinner_selectors = array(
            '.qodef-st-loader .pulse', 
            '.qodef-st-loader .double_pulse .double-bounce1', 
            '.qodef-st-loader .double_pulse .double-bounce2', 
            '.qodef-st-loader .cube', 
            '.qodef-st-loader .rotating_cubes .cube1', 
            '.qodef-st-loader .rotating_cubes .cube2', 
            '.qodef-st-loader .stripes > div', 
            '.qodef-st-loader .wave > div', 
            '.qodef-st-loader .two_rotating_circles .dot1', 
            '.qodef-st-loader .two_rotating_circles .dot2', 
            '.qodef-st-loader .five_rotating_circles .container1 > div', 
            '.qodef-st-loader .five_rotating_circles .container2 > div', 
            '.qodef-st-loader .five_rotating_circles .container3 > div', 
            '.qodef-st-loader .atom .ball-1:before', 
            '.qodef-st-loader .atom .ball-2:before', 
            '.qodef-st-loader .atom .ball-3:before', 
            '.qodef-st-loader .atom .ball-4:before', 
            '.qodef-st-loader .clock .ball:before', 
            '.qodef-st-loader .mitosis .ball', 
            '.qodef-st-loader .lines .line1', 
            '.qodef-st-loader .lines .line2', 
            '.qodef-st-loader .lines .line3', 
            '.qodef-st-loader .lines .line4', 
            '.qodef-st-loader .fussion .ball', 
            '.qodef-st-loader .fussion .ball-1', 
            '.qodef-st-loader .fussion .ball-2', 
            '.qodef-st-loader .fussion .ball-3', 
            '.qodef-st-loader .fussion .ball-4', 
            '.qodef-st-loader .wave_circles .ball', 
            '.qodef-st-loader .pulse_circles .ball' 
        );

        if (!empty($spinner_style)) {
            echo arlo_qodef_dynamic_css($spinner_selectors, $spinner_style);
        }
    }

    add_action('arlo_qodef_style_dynamic', 'arlo_qodef_smooth_page_transition_styles');
}