<?php

use TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

defined('TYPO3') or die();


/***************
 * Define TypoScript as content rendering template
 */
$GLOBALS['TYPO3_CONF_VARS']['FE']['addRootLineFields'] = 'doktype';


/***************
 * Add default RTE configuration
 */
$GLOBALS['TYPO3_CONF_VARS']['RTE']['Presets']['seragwiessner_sitepackage'] = 'EXT:seragwiessner_sitepackage/Configuration/RTE/Default.yaml';

/***************
 * PageTS
 */
ExtensionManagementUtility::addPageTSConfig('<INCLUDE_TYPOSCRIPT: source="FILE:EXT:seragwiessner_sitepackage/Configuration/TsConfig/Page/All.tsconfig">');


/***************
 * UserTS
 */
ExtensionManagementUtility::addUserTSConfig(
    '<INCLUDE_TYPOSCRIPT: source="FILE:EXT:seragwiessner_sitepackage/Configuration/TsConfig/User/User.tsconfig">'
);


/***************
 * Register Icons
 */
$iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);
$icons = [
    'tx_serag_alert' => 'ContentElements/alert.svg',
    'tx_serag_hero' => 'ContentElements/hero.svg',
    'tx_serag_menucard' => 'ContentElements/menucard.svg',
    'tx_serag_teaserbox' => 'ContentElements/teaserbox.svg',
    'tx_serag_default' => 'BackendLayouts/default.svg',
    'tx_serag_default_navleft' => 'BackendLayouts/default_navleft.svg',
    'tx_serag_home' => 'BackendLayouts/home.svg',
    'tx_serag_special_showroom' => 'BackendLayouts/special_showroom.svg',
];
foreach ($icons as $identifier => $path) {
    $iconRegistry->registerIcon(
        $identifier,
        SvgIconProvider::class,
        ['source' => 'EXT:seragwiessner_sitepackage/Resources/Public/Icons/' . $path]
    );
}


/***************
 * Register custom EXT:form configuration
 */
if (ExtensionManagementUtility::isLoaded('form')) {
    ExtensionManagementUtility::addTypoScriptSetup(trim('
        module.tx_form.settings.yamlConfigurations.1701696800 = EXT:seragwiessner_sitepackage/Configuration/Form/Setup.yaml
    '));
}
