import Mmenu from "mmenu-js";
import Mburger from "mburger-webcomponent";

const burger = document.querySelector(".navbar-toggler");
const mmenu = document.querySelector("#nav-mobile");

const langflags = document.querySelectorAll('a.lang-available');
const documentLanguage = document.documentElement.lang.slice(0, 2);


const options = {
    offCanvas: {
        position: "left-front",
        page: {
            selector: '#page'
        }
    },
    theme: "white",
    navbars: [
        {
            position: "bottom",
            content: [...langflags]
        }
    ]
}
const configuration = {
    language: documentLanguage,
    navbars: {
        breadcrumbs: {
            separator: '›'
        }
    },
    classNames: {
        selected: "current"
    },

}

if (window.innerWidth < 1024) {
    const menu = new Mmenu(mmenu, options, configuration)
}
