const klaroConfig = {
    // mustConsent: true, //overridden by EXT:klaro
    disablePoweredBy: true,
    acceptAll: true,
    hideDeclineAll: false,
    htmlTexts: true,
    services: [
        {
            name: 'googleAnalytics',
            title: 'Google Analytics',
            purposes: ['analytics'],
            cookies: [/^ga/i],
            required: false,
            optOut: false,
            default: false,
        },
        {
            name: 'mtiFontTrackingCode',
            title: 'Fonts.com',
            purposes: ['functional'],
            cookies: [/^__cf_bm/i],
            required: false,
            optOut: false,
            default: false,
        },
        {
            name: 'googleMaps',
            title: 'Google Maps',
            purposes: ['functional'],
            default: true,
        },
    ],
    styling: {
        theme: ['dark', 'top', 'wide'],
        'green1': 'var(--sw-primary)',
        'green2': 'var(--sw-primary)',
        'blue1': 'var(--sw-primary)',
        'dark1': 'var(--sw-gray-900)',
        'dark2': 'var(--sw-primary)',
        'light1': 'var(--sw-light)',
        'border-width': '0',
        'border-radius': 'var(--sw-border-radius)',
        'notice-left': '20px',
        'notice-right': '20px',
        'notice-top': '50vh',
        'notice-bottom': 'auto',
        'notice-max-width': '800px',
    },
};

window.klaroConfig = klaroConfig;

if (typeof klaroConfigTranslations !== 'undefined') {
    for (var attr in klaroConfigTranslations) {
        klaroConfig[attr] = klaroConfigTranslations[attr];
    }
}
