import Headroom from "headroom.js";

const navi = document.querySelector(".navbar-main");
const top = document.querySelector(".section-breadcrumb--top") ? document.querySelector(".section-breadcrumb--top").offsetTop : (window.innerHeight / 2);

//give the header some height to prevent flickering when nav gets pinned
navi.parentElement.style.height = navi.clientHeight + 'px';

const headroom = new Headroom(navi, {
    offset: top,
    classes : {
        // when element is initialised
        initial : "navbar",
        // when scrolling up
        pinned : "navbar--pinned",
        // when scrolling down
        unpinned : "navbar--unpinned",
        // when above offset
        top : "navbar--top",
        // when below offset
        notTop : "navbar--not-top fixed-top",
        // when at bottom of scroll area
        bottom : "navbar--bottom",
        // when not at bottom of scroll area
        notBottom : "navbar--not-bottom",
        // when frozen method has been called
        frozen: "navbar--frozen",
    },
    // callback when pinned, `this` is headroom object
    onPin: function () {
    },
    // callback when unpinned, `this` is headroom object
    onUnpin: function () {
    },
    // callback when above offset (normal), `this` is headroom object
    onTop: function () {
        this.elem.classList.remove('slideDown')
    },
    // callback when below offset (sticky), `this` is headroom object
    onNotTop: function () {
        setTimeout(function() {
            // this.elem.classList.remove('slideDown')
            navi.classList.add('slideDown')
        }, 500);

    },

});

// initialise
headroom.init();



