import * as Popper from '@popperjs/core';
import Modal from 'bootstrap/js/src/modal';
import Tooltip from 'bootstrap/js/src/tooltip';
import Collapse from 'bootstrap/js/src/collapse';
import Dropdown from 'bootstrap/js/src/dropdown';
import Popover from 'bootstrap/js/src/popover';
import Offcanvas from 'bootstrap/js/src/offcanvas';


var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'))
var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
    return new Dropdown(dropdownToggleEl)
})

var tooltipTriggerList = [].slice.call(document.querySelectorAll('.download-link'))
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new Tooltip(tooltipTriggerEl, {html: true})
})

const offcanvasElementList = document.querySelectorAll('.offcanvas')
const offcanvasList = [...offcanvasElementList].map(offcanvasEl => new Offcanvas(offcanvasEl))


/* look for responsive tables and when found apply '.is-pinned' to be able to style sticky th cells */
const tables = document.querySelectorAll('.table-responsive')

tables.forEach((table) => {
    table.addEventListener('scroll', function (e){
        e.currentTarget.classList.toggle('is-pinned', e.currentTarget.scrollLeft > 0)
    });
});
