<?php



defined('TYPO3') || die();

/***************
 * Add crop variants
 */
$desktopCropSettings = [
    'title' => 'Desktop (Landscape)',
    'allowedAspectRatios' => [
        '21:9' => [
            'title' => '21:9',
            'value' => 21 / 9
        ],
        '16:9' => [
            'title' => '16:9',
            'value' => 16 / 9
        ],
        '3:2' => [
            'title' => '3:2',
            'value' => 3 / 2
        ],
        '4:3' => [
            'title' => '4:3',
            'value' => 4 / 3
        ],
        '1:1' => [
            'title' => '1:1',
            'value' => 1.0
        ],
        '3:4' => [
            'title' => '3:4',
            'value' => 3 / 4
        ],
        'NaN' => [
            'title' => 'free',
            'value' => 0.0
        ],
    ],
    'selectedRatio' => '3:2',
    'cropArea' => [
        'x' => 0.0,
        'y' => 0.0,
        'width' => 1.0,
        'height' => 1.0,
    ]
];

$mobileCropSettings = [
    'title' => 'Mobile (Portrait)',
    'allowedAspectRatios' => [
        '2:3' => [
            'title' => '2:3',
            'value' => 2 / 3
        ],
        '3:4' => [
            'title' => '3:4',
            'value' => 3 /4
        ],
        '1:1' => [
            'title' => '1:1',
            'value' => 1.0
        ],
        '4:3' => [
            'title' => '4:3',
            'value' => 4 / 3
        ],
        '3:2' => [
            'title' => '3:2',
            'value' => 3 / 2
        ],
        'NaN' => [
            'title' => 'free',
            'value' => 0.0
        ],
    ],
    'selectedRatio' => '1:1',
    'cropArea' => [
        'x' => 0.0,
        'y' => 0.0,
        'width' => 1.0,
        'height' => 1.0,
    ]
];




/***************
 * Content Elements: Image, Textpic, Media, Textmedia
 */
$ceCropSettings['default'] = $desktopCropSettings;
$ceCropSettings['mobile'] = $mobileCropSettings;

$GLOBALS['TCA']['tt_content']['types']['image']['columnsOverrides']['image']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = $ceCropSettings;
$GLOBALS['TCA']['tt_content']['types']['textpic']['columnsOverrides']['image']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = $ceCropSettings;
$GLOBALS['TCA']['tt_content']['types']['media']['columnsOverrides']['assets']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = $ceCropSettings;
$GLOBALS['TCA']['tt_content']['types']['textmedia']['columnsOverrides']['assets']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = $ceCropSettings;




/***************
 * Hero Slider
 */

$GLOBALS['TCA']['tt_content']['types']['mask_hero_slide']['columnsOverrides']['tx_mask_slide_bgimg']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = [
    'default' => [
        'title' => 'Desktop',
        'selectedRatio' => 'default',
        'allowedAspectRatios' => [
            'default' => [
                'title' => '35vw',
                'value' => 100 / 35
            ]
        ],
    ],
    'tablet' => [
        'title' => 'Tablet (Landscape)',
        'selectedRatio' => 'default',
        'allowedAspectRatios' => [
            'default' => [
                'title' => '42.5vw',
                'value' => 1000 / 425
            ]
        ],
    ],
    'mobile' => [
        'title' => 'Mobile (Portrait)',
        'selectedRatio' => 'default',
        'allowedAspectRatios' => [
            'default' => [
                'title' => '150vw',
                'value' => 2 / 3
            ]
        ],
    ]
];

/***************
 * Page Resources
 */

$GLOBALS['TCA']['pages']['columns']['media']['config']['overrideChildTca']['columns']['crop']['config']['cropVariants'] = [
    'bgImg' => [
        'title' => 'Nav Background',
        'selectedRatio' => 'default',
        'allowedAspectRatios' => [
            'default' => [
                'title' => '32:7',
                'value' => 32 / 7
            ]
        ],
    ]
];
