<?php
defined('TYPO3') || die();

/**
 * Temporary variables
 */
$extensionKey = 'seragwiessner_sitepackage';

/**
 * Default PageTS for SeragWiessner
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::registerPageTSConfigFile(
    $extensionKey,
    'Configuration/TsConfig/Page/All.tsconfig',
    'SW: BackendLayouts, TCEMAIN, TCEFORM, RTE'
);


// Configure new fields:
$fields = array(
    'menutext1' => array(
        'label' => 'Menu Text (e.g. in Mainnavigation)',
        'exclude' => 1,
        'config' => array(
            'type' => 'text',
            'eval' => 'trim,nospace',
            'max' => 255
        ),
    ),
    'menutext2' => array(
        'label' => 'Teaser Text',
        'exclude' => 1,
        'config' => array(
            'type' => 'text',
            'eval' => 'trim,nospace',
            'max' => 255
        ),
    ),
    'teaser_image' => [
        'exclude' => true,
        'label' => 'Teaser Image',
        'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
            'teaser_image',
            [
                // Use the imageoverlayPalette instead of the basicoverlayPalette
                'overrideChildTca' => [
                    'types' => [
                        '0' => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ]
                    ],
                    'columns' => [
                        'crop' => [
                            'config' => [
                                'cropVariants' => [
                                    'default' => [
                                        'disabled' => true,
                                    ],
                                    'teaser' => [
                                        'title' => 'Teaser',
                                        'coverAreas' => [],
                                        'cropArea' => [
                                            'x' => '0.0',
                                            'y' => '0.0',
                                            'width' => '1.0',
                                            'height' => '1.0'
                                        ],
                                        'allowedAspectRatios' => [
                                            '3:2' => [
                                                'title' => '3:2',
                                                'value' => 3 / 2
                                            ],
                                            'NaN' => [
                                                'title' => 'LLL:EXT:core/Resources/Private/Language/locallang_wizards.xlf:imwizard.ratio.free',
                                                'value' => 0.0
                                            ],
                                        ],
                                        'selectedRatio' => '3:2',
                                    ],
                                ],
                            ],
                        ]
                    ]
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
            $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
        )
    ],
);

// Add new fields to pages:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('pages', $fields);

// Make fields visible in the TCEforms:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
    'pages', // Table name
    '--palette--;Additional Infos;additional_infos', // Field list to add
    '', // List of specific types to add the field list to. (If empty, all type entries are affected)
    'after:title' // Insert fields before (default) or after one, or replace a field
);

// Add the new palette:
$GLOBALS['TCA']['pages']['palettes']['additional_infos'] = array(
    'showitem' => 'menutext1,--linebreak--,menutext2,--linebreak--,teaser_image,--linebreak--,colorscheme'
);


\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTcaSelectItem(
    'pages',
    'doktype',
    [
        'LLL:EXT:seragwiessner_sitepackage/Resources/Private/Language/locallang_be.xlf:pagetype.video',
        136,
        'content-media'
    ],
    '6',
    'after'
);

$video_fields = [
    'videoteaser' => [
        'exclude' => false,
        'label' => 'LLL:EXT:seragwiessner_sitepackage/Resources/Private/Language/locallang_be.xlf:video_ce.teaser',
        'config' => [
            'type' => 'input',
            'renderType' => 'inputLink',
            'size' => 30,
            'eval' => 'trim',
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],

        ],

    ],
    'videourl' => [
        'exclude' => false,
        'label' => 'LLL:EXT:seragwiessner_sitepackage/Resources/Private/Language/locallang_be.xlf:video_ce.url',
        'l10n_mode' => '',
        'config' => [
            'type' => 'input',
            'renderType' => 'inputLink',
            'size' => 30,
            'eval' => 'trim',
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
        ],
    ],
    'videodescription' => [
        'exclude' => false,
        'label' => 'LLL:EXT:seragwiessner_sitepackage/Resources/Private/Language/locallang_be.xlf:video_ce.description',
        'config' => [
            'type' => 'text',
            'enableRichtext' => true,
            'fieldControl' => [
                'fullScreenRichtext' => [
                    'disabled' => false,
                ],
            ],
            'behaviour' => [
                'allowLanguageSynchronization' => true
            ],
        ],
    ],
];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns(
    'pages',
    $video_fields
);

$GLOBALS['TCA']['pages']['palettes']['video_config'] = array(
    'showitem' => 'videoteaser,--linebreak--,videourl,--linebreak--,videodescription'
);

\TYPO3\CMS\Core\Utility\ArrayUtility::mergeRecursiveWithOverrule(
    $GLOBALS['TCA']['pages'],
    [
        'ctrl' => [
            'typeicon_classes' => [
                136 => 'content-media'
            ],
        ],
        'types' => [

            // Video
            136 => [
                'showitem' => '
                    --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general, doktype,
                        --palette--;;title,
                    --div--;LLL:EXT:seragwiessner_sitepackage/Resources/Private/Language/locallang_be.xlf:pagetype.video,
                        --palette--;Video Configuration;video_config,
                    --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.access,
                        slug, --linebreak--,
                        starttime, endtime,--linebreak--,
                        --palette--;;visibility,
                        no_search,
                    --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
                    '
            ],
        ]
    ]
);
