<?php
namespace AmadeusAgentur\SeragWiessner\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/***************************************************************
 *  Lend from cewrapInArrayViewHelper.php
 ***************************************************************/


class ClassSelectViewHelper extends AbstractViewHelper {



    /**
     * Parse selected classes
     *
     * @return string
     */
    public function render()
    {
        $classes = $this->arguments['classes'];
        $prefix = $this->arguments['prefix'];
        $prefixExclusion = $this->arguments['prefixExclusion'];
        if(!$classes) {
            $classes = $this->renderChildren();
        }
        if($classes) {
            $classes = GeneralUtility::trimExplode(',', $classes);
            if($prefix) {
                $prefixExclusion = GeneralUtility::trimExplode(',', $prefixExclusion);
                foreach($classes as &$class) {
                    if(!in_array($class, $prefixExclusion)) {
                        $class = $prefix . $class;
                    }
                }
            }
            //return implode($classes, ' ');
            return ' ' . implode(' ', $classes );
        }
    }

    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('classes', 'string', ': CSS classes to parse', false, 'NULL');
        $this->registerArgument('prefix', 'string', ': Prefix for CSS class', false, 'NULL');
        $this->registerArgument('prefixExclusion', 'string', ': CSS classes with no prefix', false, 'NULL');
    }
}
