/* File: gulpfile.js */


// grab our gulp packages
let gulp = require('gulp'),
    browser = require('browser-sync'),
    gulpif = require('gulp-if'),
    log = require('fancy-log'),
    autoprefixer = require('gulp-autoprefixer'),
    concat = require('gulp-concat'),
    cleanCSS = require('gulp-clean-css'),
    sass = require('gulp-sass'),
    rename = require('gulp-rename'),
    sourcemaps = require('gulp-sourcemaps'),
    uglify = require('gulp-uglify'),
    plumber = require('gulp-plumber');


// environmental settings for production/deployment

const $isProduction = (process.argv[3] == "--production")




// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    return gulp.src(['src/styles/style.scss'])
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(sass({
            includePaths: ['node_modules/']
        }))

        .pipe(gulpif($isProduction, cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        )))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(gulp.dest('./'))

        //.pipe(browser.reload({stream: true}));
        .pipe(browser.stream());
}


function server(done) {
    browser.init({
        open: false,
        online: true,
        reloadOnRestart: true,
        logConnections: true,
        proxy: 'https://www.schwarzbach-tk.de',
        https: true,
        serveStatic: [{
            route: ['/wp-content/themes/schwarzbach-fresh'],
            dir: ['./']
        }],
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watch() {
    gulp.watch('src/**/*.scss').on('all', gulp.series(stylesheet));
}


// Build the "dist" folder by running all of the below tasks
// CSS HANDELD BY NEW WORKFLOW

gulp.task('build',
    gulp.parallel(stylesheet)
);

// Build the site, run the server, and watch for file changes
gulp.task('default',
    gulp.series('build', server, watch)
);

