<?php

/*** Child Theme Function  ***/


/*
 * Register frontend javascripts:
 */
if (!function_exists('avia_child_register_frontend_scripts')) {
    if (!is_admin()) {
        add_action('wp_enqueue_scripts', 'avia_child_register_frontend_scripts', 200);
    }

    function avia_child_register_frontend_scripts()
    {
        $template_url = get_template_directory_uri();
        $child_theme_url = get_stylesheet_directory_uri();

        // register scripts
        wp_enqueue_style('fonts', '//fast.fonts.net/cssapi/e7d84de4-8937-4533-86c2-5faa7c889ef7.css');


        //register styles
        //wp_register_style('avia-child', $child_theme_url . "/style.css", array(), '20200528', 'all');

        //wp_enqueue_style('avia-child');

    }
}

// amadeus Copyright im Footer einfügen (überschreibt Kriesi.at Coypright)

if (!function_exists('kriesi_backlink')) {
    function kriesi_backlink($frontpage_only = false)
    {

        $linktext = " ©" . date('Y') . " | <a href='https://www.amadeus-agentur.com' title='Webdesign und Konzeption: amadeus-agentur.com' target='_blank'><strong>amadeus-agentur.com</strong></a>";


        $link = apply_filters("kriesi_backlink", $linktext);

        return $link;
    }
}

add_action('init', function() {
    $labels = array(
        'name'                  => 'Jobs',
        'singular_name'         => 'Job',
        'menu_name'             => 'Stellenangebote',
        'name_admin_bar'        => 'Stellenangebote',
//            'archives'              => __( 'Item Archives', 'text_domain' ),
//            'attributes'            => __( 'Attribute', 'text_domain' ),
//            'parent_item_colon'     => __( 'Parent Item:', 'text_domain' ),
//            'all_items'             => __( 'All Items', 'text_domain' ),
//            'add_new_item'          => __( 'Add New Item', 'text_domain' ),
        'add_new'               => 'Neu hinzufügen',
        'new_item'              => 'Neu erstellen',
        'edit_item'             => 'Bearbeiten',
        'update_item'           => 'Aktualisieren',
        'view_item'             => 'Vorschau anzeigen',
//            'view_items'            => __( 'View Items', 'text_domain' ),
        'search_items'          => 'Suchen',
        'not_found'             => 'Nicht gefunden',
//            'not_found_in_trash'    => 'Not found in Trash',
        'featured_image'        => 'Artikelbild',
        'set_featured_image'    => 'Artikelbild festlegen',
        'remove_featured_image' => 'Artikelbild entfernen',
//            'use_featured_image'    => __( 'Use as featured image', 'text_domain' ),
//            'insert_into_item'      => __( 'Insert into item', 'text_domain' ),
//            'uploaded_to_this_item' => __( 'Uploaded to this item', 'text_domain' ),
//            'items_list'            => __( 'Items list', 'text_domain' ),
//            'items_list_navigation' => __( 'Items list navigation', 'text_domain' ),
//            'filter_items_list'     => __( 'Filter items list', 'text_domain' ),
    );
    $args = array(
        'labels'                => $labels,
        'description'           => 'Stellenangebote',
        'supports'              => array( 'title', 'editor', 'thumbnail', 'revisions', 'post-formats' ),
        'taxonomies'            => array( 'category', 'post_tag' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-id-alt',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => false,
        'exclude_from_search'   => false,
        'delete_with_user'      => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
    );
    register_post_type( 'job', $args );

    add_shortcode('amadeus_jobs', 'sc_display_job_descriptions');
});

function sc_display_job_descriptions( $atts, $content = null ) {
    $params = shortcode_atts( array('category' => 'festanstellung,ausbildung'), $atts, 'meg_jobs' );

    $args = array(
        'post_type' => 'job',
        'post_status' => 'publish',
        'category_name' => $params['category'],
        'orderby' => 'title',
        'order' => 'ASC'
    );

    $string = '';
    $query = new WP_Query( $args );
    if( $query->have_posts() ){
        $string .= '<ul>';
        while( $query->have_posts() ){
            $query->the_post();
            $string .= '<li><a href="' . get_permalink() .'">' . get_the_title() . '</a></li>';
        }
        $string .= '</ul>';
    }
    else {
        $string .= 'Aktuell sind keine freien Stellen verfügbar.';
    }

    wp_reset_query();
    return $string;
}

add_action("init", function () {
    // removing the woocommerce hook
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
    add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 8 );
});

function wooc_extra_register_fields() {?>
    <p class="form-row form-row-wide">
        <label for="reg_billing_phone"><?php _e( 'Phone', 'woocommerce' ); ?></label>
        <input type="text" class="input-text" name="billing_phone" id="reg_billing_phone" value="<?php esc_attr_e( $_POST['billing_phone'] ); ?>" />
    </p>
    <p class="form-row form-row-first">
        <label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
    </p>
    <p class="form-row form-row-last">
        <label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?><span class="required">*</span></label>
        <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
    </p>
    <div class="clear"></div>
    <?php
}
add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );

// Override checkout fields
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );

function custom_override_checkout_fields( $fields ) {
    $fields['order']['order_comments']['placeholder'] = 'Anmerkungen zu deiner Bestellung und Wunsch-Liefertermin bitte hier angeben.';
    $fields['order']['order_comments']['label'] = 'Anmerkungen zur Bestellung / Wunsch-Liefertermin';
    return $fields;
}

add_filter('avf_skin_options', 'my_custom_added_style_function');
function my_custom_added_style_function($styles = "")
{


    $schwarzbach_blau = "#004f9e";


    $gray_lighter = "#f5f5f4";
    $gray_light = "#666666";
    $gray_medium = "#c5c7c4";

    $gray_darker = "#333333";

    $default_primary = $schwarzbach_blau;
    $default_highlight = "#0381ff";
    $default_text = $gray_darker;
    $default_background = "#fff";
    $special_border = "transparent";

    $styles = [];

    $styles["Fresh Blue"] = array(
        "style"                                => "background-color:$default_primary;",
        "default_font"                         => "Arial-websave",
        "google_webfont"                       => "Arimo:400,600",
        "color_scheme"                         => "Schwarzbach Fresh 2017",

        // header
        "colorset-header_color-bg"             => "#ffffff",
        "colorset-header_color-bg2"            => "#f8f8f8",
        "colorset-header_color-primary"        => "$default_primary",
        "colorset-header_color-secondary"      => "#444444",
        "colorset-header_color-color"          => "$default_text",
        "colorset-header_color-border"         => "transparent",
        "colorset-header_color-img"            => "",
        "colorset-header_color-customimage"    => "",
        "colorset-header_color-pos"            => "top center",
        "colorset-header_color-repeat"         => "repeat",
        "colorset-header_color-attach"         => "scroll",
        "colorset-header_color-heading"        => "$gray_darker",
        "colorset-header_color-meta"           => "#808080",

        // main
        "colorset-main_color-bg"               => "#ffffff",
        "colorset-main_color-bg2"              => "#fcfcfc",
        "colorset-main_color-primary"          => "$default_primary",
        "colorset-main_color-secondary"        => "$default_highlight",
        "colorset-main_color-color"            => "$default_text",
        "colorset-main_color-border"           => "$gray_medium",
        "colorset-main_color-img"              => "",
        "colorset-main_color-customimage"      => "",
        "colorset-main_color-pos"              => "top center",
        "colorset-main_color-repeat"           => "repeat",
        "colorset-main_color-attach"           => "scroll",
        "colorset-main_color-heading"          => "$gray_darker",
        "colorset-main_color-meta"             => "#919191",

        // alternate
        "colorset-alternate_color-bg"          => "$gray_lighter",
        "colorset-alternate_color-bg2"         => "$default_primary",
        "colorset-alternate_color-primary"     => "$default_primary",
        "colorset-alternate_color-secondary"   => "$default_highlight",
        "colorset-alternate_color-color"       => "$default_text",
        "colorset-alternate_color-border"      => "transparent",
        "colorset-alternate_color-img"         => "",
        "colorset-alternate_color-customimage" => "",
        "colorset-alternate_color-pos"         => "top center",
        "colorset-alternate_color-repeat"      => "repeat",
        "colorset-alternate_color-attach"      => "scroll",
        "colorset-alternate_color-heading"     => "$gray_darker",
        "colorset-alternate_color-meta"        => "#8f8f8f",

        // Footer
        "colorset-footer_color-bg"             => "#ffffff",
        "colorset-footer_color-bg2"            => "#ffffff",
        "colorset-footer_color-primary"        => "$default_text",
        "colorset-footer_color-secondary"      => "$default_primary",
        "colorset-footer_color-color"          => "$default_text",
        "colorset-footer_color-border"         => "$gray_medium",
        "colorset-footer_color-img"            => "",
        "colorset-footer_color-customimage"    => "",
        "colorset-footer_color-pos"            => "top center",
        "colorset-footer_color-repeat"         => "repeat",
        "colorset-footer_color-attach"         => "scroll",
        "colorset-footer_color-heading"        => "$default_primary",
        "colorset-footer_color-meta"           => "#919191",

        // Socket
        "colorset-socket_color-bg"             => "$default_primary",
        "colorset-socket_color-bg2"            => "$gray_medium",
        "colorset-socket_color-primary"        => "$gray_lighter",
        "colorset-socket_color-secondary"      => "$gray_lighter",
        "colorset-socket_color-color"          => "$gray_medium",
        "colorset-socket_color-border"         => "$default_primary",
        "colorset-socket_color-img"            => "",
        "colorset-socket_color-customimage"    => "",
        "colorset-socket_color-pos"            => "top center",
        "colorset-socket_color-repeat"         => "repeat",
        "colorset-socket_color-attach"         => "scroll",
        "colorset-socket_color-heading"        => "#ffffff",
        "colorset-socket_color-meta"           => "#999999",

        //body bg
        "color-body_style"                     => "stretched",
        "color-body_color"                     => "#ffffff", //bg
        "color-body_fontcolor"                 => "$default_text", //font
        "color-body_attach"                    => "scroll",
        "color-body_repeat"                    => "repeat",
        "color-body_pos"                       => "top center",
        "color-body_img"                       => "",
        "color-body_customimage"               => "",
    );

    return $styles;
}


add_action( 'load-themes.php', 'add_theme_caps' );

function wooc_validate_extra_register_fields( $username, $email, $validation_errors ) {
    if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
        $validation_errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
    }
    if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
        $validation_errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!.', 'woocommerce' ) );
    }
    return $validation_errors;
}
add_action( 'woocommerce_register_post', 'wooc_validate_extra_register_fields', 10, 3 );

function wooc_save_extra_register_fields( $customer_id ) {
    if ( isset( $_POST['billing_phone'] ) ) {
        // Phone input filed which is used in WooCommerce
        update_user_meta( $customer_id, 'billing_phone', sanitize_text_field( $_POST['billing_phone'] ) );
    }
    if ( isset( $_POST['billing_first_name'] ) ) {
        //First name field which is by default
        update_user_meta( $customer_id, 'first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
        // First name field which is used in WooCommerce
        update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
    }
    if ( isset( $_POST['billing_last_name'] ) ) {
        // Last name field which is by default
        update_user_meta( $customer_id, 'last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
        // Last name field which is used in WooCommerce
        update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
    }
}
add_action( 'woocommerce_created_customer', 'wooc_save_extra_register_fields' );

function add_theme_caps() {
    // gets the author role
    $role = get_role( 'subscriber' );

    // This only works, because it accesses the class instance.
    // would allow the author to edit others' posts for current theme only
    $role->add_cap( 'read_private_pages' );
    $role->add_cap( 'read_private_posts' );
}