/* File: gulpfile.js */


// grab our gulp packages
var gulp = require('gulp'),
    del = require('del'),
    browser = require('browser-sync'),
    gulpif = require('gulp-if'),
    log = require('fancy-log'),
    autoprefixer = require('gulp-autoprefixer'),
    concat = require('gulp-concat'),
    cleanCSS = require('gulp-clean-css'),
    less = require('gulp-less'),
    sourcemaps = require('gulp-sourcemaps');


//
var basePaths = {
    public: '../Resources/Public/',
    private: '../Resources/Private/'
};

var paths = {
    styles: {
        src: basePaths.private + 'Less/',
        dest: basePaths.public + 'Css/'
    },
    scripts: {
        src: basePaths.private + 'JavaScript/',
        dest: basePaths.public + 'JavaScript/'
    },
    images: basePaths.public + 'Images/'

};


// environmental settings for production/deployment

var $isProduction = (process.argv[3] == "--production"),
    $environment = (process.argv[4] == "--live" ? 'https://www.pflaum-logistik.de' : 'https://pflaum.ddev.site');


var isProduction = false,
    sourceMap = true,
    deployDev = true,
    deployLive = false;

if ($isProduction) {
    isProduction = true;
    sourceMap = false;
    deployDev = true;
    deployLive = true;
}


function clean(done) {
    del([
        '../Resources/Public/Css/**/*',
        '../Resources/Public/JavaScript/**/*',
        '!../Resources/Public/JavaScript/klaro-config.js',
        '../Resources/Public/Less/',
    ], {
        force: true
    });
    done();
}


// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    return gulp.src(paths.styles.src + 'theme.less')
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(less({
            paths: ['node_modules'],
        })).on('error', function (err) {
            log(err);
        })
        .pipe(autoprefixer())
        .pipe(cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        ))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(gulp.dest('../Resources/Public/Css'))

        .pipe(browser.reload({stream:true}));
}

function jsLibsCopy() {
    return gulp.src([
        './node_modules/jquery/dist/jquery.min.js',
    ])
        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}


function jsLibsConcat() {
    return gulp.src([
        './node_modules/bootstrap/js/affix.js',
        './node_modules/bootstrap/js/collapse.js',
        './node_modules/slick-carousel/slick/slick.js',
        './node_modules/fancybox/dist/js/jquery.fancybox.js',
        './node_modules/headroom.js/dist/headroom.js',
        './node_modules/headroom.js/dist/jQuery.headroom.js',
    ])
        .pipe(concat('libs.js'))
        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}

function jsInit() {
    return gulp.src(paths.scripts.src + '*.js')
        .pipe(concat('init.js'))
        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}


function server(done) {
    browser.init({
        open: false,
        online: true,
        reloadOnRestart: true,
        logConnections: true,
        https: true,
        proxy: $environment,
        serveStatic: [{
            route: 'typo3conf/ext/pflaum_logistik/Resources/Public',
            dir: ['../Resources/Public/']
        }],
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watch() {
    gulp.watch('../Resources/Private/Less/**/*.less').on('all', gulp.series(stylesheet));
    gulp.watch('../Resources/Private/JavaScript/**/*.js').on('all', gulp.series(jsLibsConcat, jsLibsCopy, jsInit, browser.reload));
}


// Build the "dist" folder by running all of the below tasks
gulp.task('build',
    gulp.series(clean, gulp.parallel(stylesheet, jsLibsCopy, jsLibsConcat, jsInit))
);

// Build the site, run the server, and watch for file changes
gulp.task('default',
    gulp.series(gulp.parallel(stylesheet, jsLibsCopy, jsLibsConcat, jsInit),server, watch)
);
