@extends('layouts.app')

@section('content')

    <div class="uk-container">
        <div>
            <div class="uk-card uk-card-default uk-width-2-3@m uk-align-center">

                <div class="uk-card-header">
                    <h3 class="uk-card-title">{{ __('auth.login_headline') }}</h3>
                </div>

                <div class=" uk-card-body ">
                    <form class="uk-form-horizontal uk-margin-large" method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="uk-margin">
                            <label class="uk-form-label" for="email">{{ __('auth.emailaddress') }}</label>
                            <div class="uk-form-controls">
                                <input id="email" type="email"
                                       class="uk-input {{ $errors->has('email') ? ' is-invalid' : '' }}"
                                       name="email" value="{{ old('email') }}" required autofocus>

                                @if ($errors->has('email'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label class="uk-form-label" for="password">{{ __('auth.password') }}</label>
                            <div class="uk-form-controls">
                                <input id="password" type="password"
                                       class="uk-input {{ $errors->has('password') ? ' is-invalid' : '' }}"
                                       name="password" required>
                                @if ($errors->has('password'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('password') }}</strong>
                                   </span>
                                @endif
                            </div>
                        </div>

                        <div class="uk-margin">
                            <div class="uk-form-controls">
                                <input type="submit" class="uk-button uk-button-primary"
                                       value="{{ __('auth.login') }}">
                            </div>
                        </div>

                    </form>

                </div>
                <div class="uk-card-footer">
                    Noch kein Benutzerkonto erstellt? <a href="/register">Hier gehts zur Benutzerkontoerstellung</a>
                </div>
            </div>
        </div>

@endsection



    {{--<div class="container">--}}
    {{--<div class="row justify-content-center">--}}
    {{--<div class="col-md-8">--}}
    {{--<div class="card">--}}
    {{--<div class="card-header"></div>--}}

    {{--<div class="card-body">--}}
    {{--<form>--}}

    {{--<div class="form-group row">--}}
    {{--<label for="email"--}}
    {{--class="col-sm-4 col-form-label text-md-right"></label>--}}

    {{--<div class="col-md-6">--}}
    {{--<input id="email" type="email"--}}
    {{--class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"--}}
    {{--name="email" value="{{ old('email') }}" required autofocus>--}}


    {{--</div>--}}
    {{--</div>--}}

    {{--<div class="form-group row">--}}
    {{--<label for="password"--}}
    {{--class="col-md-4 col-form-label text-md-right"></label>--}}

    {{--<div class="col-md-6">--}}


    {{--</div>--}}
    {{--</div>--}}

    {{--<div class="form-group row">--}}
    {{--<div class="col-md-6 offset-md-4">--}}
    {{--<div class="checkbox">--}}
    {{--<label>--}}
    {{--<input type="checkbox"--}}
    {{--name="remember" {{ old('remember') ? 'checked' : '' }}> {{ __('Remember Me') }}--}}
    {{--</label>--}}
    {{--</div>--}}
    {{--</div>--}}
    {{--</div>--}}

    {{--<div class="form-group row mb-0">--}}
    {{--<div class="col-md-8 offset-md-4">--}}
    {{--<button type="submit" class="btn btn-raised btn-primary">--}}
    {{--{{ __('Login') }}--}}
    {{--</button>--}}

    {{--<a class="btn btn-raised btn-link" href="{{ route('password.request') }}">--}}
    {{--{{ __('Passwort vergessen?') }}--}}
    {{--</a>--}}
    {{--</div>--}}
    {{--</div>--}}
    {{--</form>--}}
    {{--</div>--}}
    {{--</div>--}}
    {{--</div>--}}
    {{--</div>--}}
    {{--</div>--}}
