/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require("babel-polyfill");


import jQuery from 'jquery';
import jQueryScrollTo from 'jquery.scrollto';
import UIkit from 'uikit';
import Icons from 'uikit/dist/js/uikit-icons';

import select2 from 'select2';

UIkit.use(Icons);

// components can be called from the imported UIkit reference
// UIkit.notification('Debug Mode on');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

// Vue.component('example-component', require('./components/ExampleComponent.vue'));
// Vue.component('v-select', vSelect);


let selectColor = {};
let selectBreed = {};
let mainModal = {};
let selectedBreedId = null;
let selectedBreed = null;


jQuery(($) => {
    console.log("Hello");


    selectColor = $('.selectColor.select2');
    selectBreed = $('.selectBreed.select2');
    mainModal = $('#mainModal');


    typeof lastBreed != "undefined" ? $('input[type=hidden][name=breed]').val(lastBreed) : void(0);
    typeof lastColor != "undefined" ? $('input[type=hidden][name=color]').val(lastColor) : void(0);


    typeof lastPosition != "undefined" && lastPosition != null ? setTimeout(() => {
        location.href = '#' + lastPosition
    }, 100) : void(0);


    if (typeof breeds != "undefined") {


        selectColor.select2({placeholder: 'Rasse zuerst wählen', width: '100%'});
        selectBreed.select2({
            placeholder: 'Rasse wählen',
            data: breeds,
            width: '100%'
        })
            .on('select2:select', (breed) => {


                selectedBreedId = $(breed.currentTarget).val();
                selectedBreed = breeds[selectedBreedId - 1];

                console.log(selectedBreedId);
                console.log(selectedBreed);


                // $(breed.currentTarget).val(selectedBreedId).change();

                //
                selectColor.select2('destroy').empty().html('<option></option>');
                let data = colors[selectedBreed.value];

                selectColor.select2({
                    width: '100%',
                    placeholder: 'Farbe wählen',
                    data: data
                }).change().on('select2:select', (color) => {
                    // selectColor.val($(color.currentTarget).val()).change();

                    console.log($(color.currentTarget).val());
                    console.log($(color.currentTarget).select2('data')[0].text.trim());
                    $('input[type=hidden][name=breed]').val($(breed.currentTarget).val());
                    $('input[type=hidden][name=color]').val($(color.currentTarget).val());
                    $('input[type=hidden][name=aocColor]').val($(color.currentTarget).select2('data')[0].text.trim() == 'AOC' ? -1 : "")
                });
            });

        if (edit == true && lastBreed > 0 && lastColor > 0) {

            let data = colors[breeds[lastBreed].value];

            selectColor.select2({
                placeholder: 'Farbe wählen',
                data: data,
                width: '100%'
            }).on('select2:select', (color) => {
                // selectColor.val($(color.currentTarget).val()).change();

                console.log($(color.currentTarget).val());

                $('input[type=hidden][name=color]').val($(color.currentTarget).val());
            });
        }

        $('button[type=submit]').on('click', (evt, elem) => {
            let $obj = $(evt.currentTarget);
            let $input = $('input[type=text][name=aocColor]');
            let $inputHidden = $('input[type=hidden][name=aocColor]');
            if ($inputHidden.val() == '-1') {
                evt.preventDefault();

                UIkit.modal(mainModal).show();


                $('#mainModal .uk-button-primary').off('click').on('click', (evt) => {
                    console.log($input.val());
                    $inputHidden.val($input.val()
                    );
                    setTimeout(() => {
                        $obj.click()
                    }, 1);
                });
            }
        });


    }
    $('li>a.addMultipleAnimals').on('click', (evt) => {
        let $value = $(evt.currentTarget).data('val');
        $('input[type=hidden][name=amount]').val($value);
        setTimeout(() => {
            $('#addSingleAnimalForm button[type=submit]').click();
        }, 1);

    })


});