<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOwnbreedingColumnToAnimals extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('animal_aviaries', function (Blueprint $table) {
            $table->boolean('ownBreeding')->default(true)->after('championship');
        });

        Schema::table('animal_pairs', function (Blueprint $table) {
            $table->boolean('ownBreeding')->default(true)->after('championship');
        });

        Schema::table('animals', function (Blueprint $table) {
            $table->boolean('ownBreeding')->default(true)->after('championship');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('animal_aviaries', function (Blueprint $table) {
            $table->dropColumn('ownBreeding');
        });

        Schema::table('animal_pairs', function (Blueprint $table) {
            $table->dropColumn('ownBreeding');
        });

        Schema::table('animals', function (Blueprint $table) {
            $table->dropColumn('ownBreeding');
        });

    }
}
