<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExhibitionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('exhibitions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('location');
            $table->dateTime('startDate');
            $table->dateTime('endDate');
            $table->dateTime('registrationEnd');
            $table->decimal('priceFee',5,2)->default(0);
            $table->decimal('priceCatalog',5,2)->default(0);
            $table->decimal('priceSpecial',5,2)->default(0);
            $table->decimal('priceSpecialBonus',5,2)->default(0);
            $table->decimal('pricePrize',5,2)->default(0);
            $table->decimal('priceAviaries',5,2)->default(0);
            $table->decimal('pricePairs',5,2)->default(0);
            $table->decimal('priceSingle',5,2)->default(0);
            $table->decimal('priceNewBreed',5,2)->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exhibitions');
    }
}
