<?php

namespace App\Http\Controllers;

use App\Exhibitor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if ( Auth::user()->banned == 1) {
            return redirect()->action('HomeController@banned')->with('banReason',Auth::user()->banReason);
        }

        $exhibitors = Exhibitor::where('userId',Auth::id())->get();

        return view('home',compact('exhibitors'));
    }


    public function banned()
    {
        $banReason = Auth::user()->banReason;
        Auth::logout();



        return view('auth.login')->withErrors(['banReason'=>$banReason]);
    }
}
