@extends('layouts.app')
@section('content')
    <div class="uk-container">
        <div uk-grid class="uk-grid-medium">
            <div class="uk-grid">
                <div class="uk-width-1-1">
                    <div class="uk-card uk-card-small uk-card-default">
                        <h5 class="uk-card-header">Ameldungen zur {{$exhibition->name}}</h5>


                        <table class="uk-table uk-table-divider  uk-table-small">
                            <tr>
                                <th>Name</th>
                                <th colspan="3">Aussteller</th>
                                <th colspan="2">Aussteller</th>
                                <th colspan="5">Tiere</th>
                            </tr>
                            <tr>
                                <th></th>
                                <th>abgesendet</th>
                                <th>Aussteller</th>
                                <th></th>

                                <th>gesamt</th>
                                <th>Einzeltiere</th>
                                <th>Paare / Stämme</th>
                                <th>Volieren</th>
                                <th>Broken ?</th>
                            </tr>


                            @foreach($registrations as $reg)

                                <tr class="{{$reg->locked ? 'uk-alert-success' : 'uk-alert-warning'}}">
                                    <td><a href="/anmeldung/{{$reg->id}}">{{$reg->id}}</a></td>
                                    <td>{{$reg->locked}}</td>
                                    <td>{{ \App\Exhibitor::find($reg->exhibitorId)->getFullname()}}</td>
                                    <td><small uk-tooltip="">{{ \App\Exhibitor::find($reg->exhibitorId)->userId}}</small></td>

                                    <td>
                                        {{\App\Animal::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()
                                        + \App\AnimalPair::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()
                                        + \App\AnimalAviary::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()}}
                                    </td>
                                    <td>{{\App\Animal::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()}}</td>
                                    <td>{{\App\AnimalPair::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()}}</td>
                                    <td>{{\App\AnimalAviary::where('exhibitionId',$exhibition->id)->where('exhibitorId',$reg->exhibitorId)->get()->count()}}</td>
                                    <td>{{\App\Ḩelper\FixHelper::hasBrokenColors($reg)}}</td>

                                </tr>


                            @endforeach
                        </table>
                    </div>
                </div>
            </div>


    </div>
@endsection