<?php

namespace App\Http\Controllers;

use App\AnimalAviary;
use App\Helper\RegistrationHelper;
use App\Registration;
use Illuminate\Http\Request;

class AnimalAviaryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $animalAviary = new AnimalAviary();


        $animalAviary->sellprice = $request->sellPrice ?? 0;
        $animalAviary->exhibitionId = $request->exhibition;
        $animalAviary->exhibitorId = $request->exhibitor;
        $animalAviary->colorId = $request->color;
        $animalAviary->breedId = $request->breed;

        $animalAviary->championship = $request->championship == 'on' ? 1 : 0;


        $animalAviary->aocColor = $request->aocColor ?? '';
        $animalAviary->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

        $animalAviary->save();


        $request->session()->put('last_breed', $request->breed);
        $request->session()->put('last_color', $request->color);


        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param AnimalAviary $aviary
     * @return void
     */
    public function show(AnimalAviary $aviary)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param AnimalAviary $aviary
     * @return void
     */
    public function edit(AnimalAviary $aviary)
    {
        $breed_options = RegistrationHelper::getSelect2Breeds($aviary->breedId);
        $color_options = RegistrationHelper::getSelect2Colors($aviary->colorId);
        $type = "aviary";
        $animal = $aviary;

        $context = compact("animal", "breed_options", "color_options", "type");


        return view('animals.edit', $context);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param AnimalAviary $aviary
     * @return void
     */
    public function update(Request $request, AnimalAviary $aviary)
    {
        $animal = $aviary;

        $animal->sellprice = $request->sellPrice ?? 0;
        $animal->colorId = $request->color;
        $animal->breedId = $request->breed;
        $animal->championship = $request->championship == 'on' ? 1 : 0;
        $animal->aocColor = $request->aocColor ?? '';
        $animal->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

        $animal->save();

        $registration = Registration::where('exhibitionId', $animal->exhibitionId)->where('exhibitorId', $animal->exhibitorId)->first();

        return redirect()->action('RegistrationController@show', [$registration]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param AnimalAviary $aviary
     * @return void
     */
    public function destroy(AnimalAviary $aviary)
    {

        $aviary->delete();
        return redirect()->back();
    }
}
