@isset($animals)
    <div class="uk-grid-small uk-margin-large-bottom" uk-grid>
        @foreach($championships as $championship)
            <div class="uk-width-1-3@m">
                <div class="uk-card uk-card-default uk-card-small">
                    <form class="uk-form-stacked" method="post" action="/championship/{{$championship->id}}">
                        <h5 class="uk-card-header">
                            {{$championship->name}}
                        </h5>
                        <div class="uk-card-body">
                            <p>Teilnahme mit:</p>
                            @php( $participation = \App\Helper\ChampionShipHelper::getParticipations($championship,$exhibitor->id))

                            @foreach(\App\Helper\ChampionShipHelper::getReadableAnimalNames($animals) as $colorId => $colorName)
                                <div class="uk-margin-small">
                                    <label><input class="uk-checkbox" type="checkbox"
                                                  name="color_{{$colorId}}"{{in_array($colorId,$participation) ? "checked" : ''}}>&nbsp;{{$colorName}}</label>
                                </div>
                            @endforeach

                        </div>
                        <div class="uk-card-footer">
                            @method('put')
                            @csrf
                            <input type="hidden" name="exhibitorId" value="{{$exhibitor->id}}">
                            <button type="submit" class="uk-button uk-button-primary">Speichern</button>
                        </div>
                    </form>
                </div>
            </div>
        @endforeach

    </div>
@endisset()