@extends('layouts.app')

@section('content')
    <div class="uk-container">
        <div class="uk-width-3-4 uk-align-center">
            <div class="uk-card uk-card-default">
                <div class="uk-card-header">{{_("Aussteller bearbeiten")}}</div>
                <script>
                    function validateCreateForm() {
                        var testcode = document.forms["createExhibitor"]["iban"].value;
                        var CODE_LENGTHS = {
                            AD: 24, AE: 23, AT: 20, AZ: 28, BA: 20, BE: 16, BG: 22, BH: 22, BR: 29,
                            CH: 21, CY: 28, CZ: 24, DE: 22, DK: 18, DO: 28, EE: 20, ES: 24,
                            FI: 18, FO: 18, FR: 27, GB: 22, GI: 23, GL: 18, GR: 27, GT: 28, HR: 21,
                            HU: 28, IE: 22, IL: 23, IS: 26, IT: 27, JO: 30, KW: 30, KZ: 20, LB: 28,
                            LI: 21, LT: 20, LU: 20, LV: 21, MC: 27, MD: 24, ME: 22, MK: 19, MR: 27,
                            MT: 31, MU: 30, NL: 18, NO: 15, PK: 24, PL: 28, PS: 29, PT: 25, QA: 29,
                            RO: 24, RS: 22, SA: 24, SE: 24, SI: 19, SK: 24, SM: 27, TN: 24, TR: 26,
                            AL: 28, BY: 28, CR: 22, EG: 29, GE: 22, IQ: 23, LC: 32, SC: 31, ST: 25,
                            SV: 28, TL: 23, UA: 29, VA: 22, VG: 24, XK: 20
                        };

                        if (testcode == null || testcode == "") {
                            return true;
                        }

                        var iban = String(testcode).toUpperCase().replace(/[^A-Z0-9]/g, ''), // keep only alphanumeric characters
                            code = iban.match(/^([A-Z]{2})(\d{2})([A-Z\d]+)$/), // match and capture (1) the country code, (2) the check digits, and (3) the rest
                            digits;
                        // check syntax and length
                        if (!code || iban.length !== CODE_LENGTHS[code[1]]) {
                            alert("Die eingetragene IBAN ist falsch. Stellen Sie sicher, dass Sie keine Leerzeichen eingegeben haben und der Ländercode vorhanden ist");
                            return false;
                        }
                        // rearrange country code and check digits, and convert chars to ints
                        digits = (code[3] + code[1] + code[2]).replace(/[A-Z]/g, function (letter) {
                            return letter.charCodeAt(0) - 55;
                        });
                        // final check
                        var checksum = digits.slice(0, 2), fragment;
                        for (var offset = 2; offset < digits.length; offset += 7) {
                            fragment = String(checksum) + digits.substring(offset, offset + 7);
                            checksum = parseInt(fragment, 10) % 97;
                        }
                        if (checksum === 1) {
                            return true;
                        }
                        else {
                            alert("Die eingetragene IBAN ist falsch. Stellen Sie sicher, dass Sie keine Leerzeichen eingegeben haben und der Ländercode vorhanden ist");
                            return false;
                        }
                    }
                </script>
                <form name="createExhibitor" class="uk-form-horizontal" action="/exhibitor/{{$exhibitor->id}}" method="post" onsubmit="return validateCreateForm()">
                    <div class="uk-card-body">
                        @if (session('status'))
                            <div class="alert alert-success">
                                {{ session('status') }}
                            </div>
                        @endif


                        @csrf
                        @method('put')
                        <div class="uk-margin">
                            <label for="inputFirstName" class="uk-form-label">{{__("Name")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-2">
                                    <input type="text" class="uk-input" id="inputFirstName"
                                           value="{{$exhibitor->firstName ?? ''}}" name="firstName"
                                           placeholder="{{__("Vorname")}}"
                                           required>
                                </div>
                                <div class="uk-width-1-2">
                                    <input type="text" class="uk-input" id="inputLastName"
                                           value="{{$exhibitor->lastName ?? ''}}" name="lastName" required
                                           placeholder="{{__("Nachname")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="inputPassword" class="uk-form-label">{{__("Anschrift")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputAddress" name="address" required
                                           value="{{$exhibitor->address ?? ''}}"
                                           placeholder="{{__("Straße und Hausnummer")}}">
                                </div>
                                <div class="uk-width-1-4">
                                    <input type="text" class="uk-input" id="inputZip" name="zip" required
                                           value="{{$exhibitor->zip ?? ''}}"
                                           placeholder="{{__("Postleitzahl")}}">
                                </div>
                                <div class="uk-width-3-4">
                                    <input type="text" class="uk-input" id="inputCity" name="city" required
                                           value="{{$exhibitor->city ?? ''}}"
                                           placeholder="{{__("Ort")}}">
                                </div>
                                <div class="uk-width-1-1">
                                    <select class="uk-select" id="inputCountry" name="country" required
                                            value="{{$exhibitor->country ?? ''}}"
                                            placeholder="{{__("Land")}}">
                                        @include('exhibitor.partial.countrylist');
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="inputPhone" class="uk-form-label">{{__("Telefon")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputPhone" name="telephone" required
                                           value="{{$exhibitor->telephone?? ''}}"
                                           placeholder="{{__("Telefonnummer")}}">
                                </div>
                            </div>
                        </div>
                        <div class="uk-margin">
                            <label for="inputEMail" class="uk-form-label">{{__("E-Mailadresse")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputEMail" name="email" required
                                           value="{{$exhibitor->email?? ''}}"
                                           placeholder="{{__("E-Mailaddresse")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="inputBankname" class="uk-form-label">{{__("Bank")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1 ">
                                    <input type="text" class="uk-input" id="inputBankname" name="bankAccountOwner"
                                           value="{{$exhibitor->bankAccountOwner ?? ''}}"
                                           placeholder="{{__("Konotinhaber (falls Abweichend)")}}">
                                </div>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputBankname" name="bankName"
                                           value="{{$exhibitor->bankName ?? ''}}"
                                           placeholder="{{__("Bankname")}}">
                                </div>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputIBAN" name="iban"
                                           value="{{$exhibitor->iban ?? ''}}"
                                           placeholder="{{__("IBAN")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">

                            <label for="inputRegNo" class="uk-form-label">{{__("Registriernr.")}}.</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputRegNo" name="regno" required
                                           value="{{$exhibitor->regno ?? ''}}"
                                           placeholder="{{__("Veterinär-Registriernummer")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="inputVetNo" class="uk-form-label">{{__("Veterinäramt")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputVetNo" name="vet"
                                           value="{{$exhibitor->vet ?? ''}}"
                                           placeholder="{{__("Veterinäramt")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="inputVerein" class="uk-form-label">{{__("Verein")}}</label>
                            <div class="uk-form-controls uk-grid-small" uk-grid>
                                <div class="uk-width-1-1">
                                    <input type="text" class="uk-input" id="inputVerein" name="society" required
                                           value="{{$exhibitor->society ?? ''}}"
                                           placeholder="{{__("Verein")}}">
                                </div>
                            </div>
                        </div>

                        <div class="uk-margin">
                            <label for="" class="uk-form-label">{{__("Aussteller/in")}}</label>
                            <div class="uk-form-controls uk-margin uk-grid-small uk-child-width-auto uk-grid">

                                <div class="">
                                    <label for="inlineRadio1">
                                        <input type="radio" name="exhibitorType" id="inlineRadio1" value="1"
                                               class="uk-radio"
                                               {{$exhibitor->type == 1 ? "checked" :''}}
                                               required>
                                        {{__("Senioren")}}
                                    </label>
                                </div>
                                <div class="">
                                    <label for="inlineRadio2">
                                        <input type="radio" name="exhibitorType" id="inlineRadio2" value="2"
                                               class="uk-radio"
                                               {{$exhibitor->type == 2 ? "checked" :''}}
                                               required>
                                        {{__("Jugendlicher")}}
                                    </label>
                                </div>

                            </div>
                        </div>
                    </div>


                    <div class="uk-card-footer">
                        @csrf
                        <button type="submit" class="uk-button uk-button-primary uk-float-right"><span
                                    uk-icon="plus"></span>
                            &nbsp;{{__("Speichern")}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
