@extends('layouts.app')

@section('content')
    <form action="/exhibition" method="post" class="uk-form-horizontal" enctype="multipart/form-data">
        @csrf
        <div class="uk-container">

            @if (session('status'))
                <div class="alert alert-success">
                    {{ session('status') }}
                </div>
            @endif

            <h1 class="title">Neue Schau anlegen</h1>
                <hr>
            <div uk-grid>

                <div class="uk-width-1-2@m">
                    <div class="uk-card uk-card-default">
                        <div class="uk-card-header">
                            <div class="uk-card-title">Allgemein</div>
                        </div>

                        <div class="uk-card-body">
                            <div class="uk-margin">
                                <label for="inputFirstName" class="uk-form-label">Name</label>
                                <div class="uk-form-controls">
                                    <input type="text" class="uk-input" id="inputFirstName"
                                           value="{{$exhibition->name ?? ''}}" name="name"
                                           placeholder="Name">
                                </div>

                            </div>
                            <div class="uk-margin">
                                <label for="inputLocation" class="uk-form-label">Ort</label>
                                <div class="uk-form-controls">

                                    <input type="text" class="uk-input" id="inputLocation"
                                           value="{{$exhibition->location ?? ''}}" name="location"
                                           placeholder="Ort">

                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputStartDate" class="uk-form-label">Beginnt am</label>
                                <div class="uk-form-controls">

                                    <input type="date" class="uk-input" id="inputStartDate"
                                           value="{{$exhibition->startDate ?? ''}}" name="startDate"
                                           placeholder="Datum">

                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputEndDate" class="uk-form-label">Endet am</label>
                                <div class="uk-form-controls">

                                    <input type="date" class="uk-input" id="inputEndDate"
                                           value="{{$exhibition->endDate ?? ''}}" name="endDate"
                                           placeholder="Datum">

                                </div>
                            </div>

                            <div class="uk-margin">
                                <label for="inputregEndDate" class="uk-form-label">Meldeschluss</label>
                                <div class="uk-form-controls">

                                    <input type="date" class="uk-input" id="inputregEndDate"
                                           value="{{$exhibition->registrationEnd ?? ''}}" name="registrationEnd"
                                           placeholder="Datum">

                                </div>
                            </div>

                            <div class="uk-margin">
                                <label for="inputLocationCapacity" class="uk-form-label">Hallenkapazität</label>
                                <div class="uk-form-controls">

                                    <input type="number" class="uk-input" id="inputLocationCapacity"
                                           value="{{$exhibition->registrationEnd ?? ''}}" name="locationCap"
                                           placeholder="Hallenkapazität (NYI)">

                                </div>
                            </div>

                            <div class="uk-margin">
                                <label for="inputExhibNotes" class="uk-form-label">Anmerkungen</label>
                                <div class="uk-form-controls">

                                    <textarea class="uk-input" id="inputExhibNotes" title="Anmerkung mit 'WICHTIG:' beginnen um den Text in roter Schrift anzeigen zu lassen"
                                              value="{{$exhibition->notes ?? ''}}" name="notes"
                                              placeholder="Anmerkungen" rows="3"></textarea>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="uk-width-1-2@m">
                    <div class="uk-card uk-card-default">
                        <div class="uk-card-header">
                            <div class="uk-card-title">Dateien</div>
                        </div>
                        <div class="uk-card-body">

                            <div class="uk-margin">
                                <label for="terms" class="uk-form-label">Ausstellungsbestimmungen</label>
                                <div class="uk-form-controls">
                                    <input type="file" name="terms" id="terms">
                                </div>
                            </div>

                            <div class="uk-margin">
                                <label for="logo" class="uk-form-label">Logo</label>
                                <div class="uk-form-controls">

                                    <input type="file"
                                           value="{{$exhibition->logo ?? ''}}" name="logo">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="uk-width-1-2@m">
                    <div class="uk-card uk-card-default">
                        <div class="uk-card-header">
                            <div class="uk-card-title">Preise / Gebühren</div>
                        </div>
                        <div class="uk-card-body">

                            @foreach($prices as $label=>$price)
                                <div class="uk-margin">
                                    <label for="input{{$price}}" class="uk-form-label">{{$label}}</label>
                                    <div class="uk-form-controls">
                                        <input type="number" class="uk-input" id="input{{$price}}"
                                               value="{{$exhibition->$price ?? ''}}"
                                               name="{{$price}}"
                                               step='0.10'
                                               placeholder="">
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </div>
            </div>


            <h2>Meisterschaften</h2>
            <hr>

            <div class="uk-card uk-card-default uk-width-3-4@m uk-align-center">
                <div class="uk-card-header">
                    <div class="uk-card-title">Neue Schau anlegen</div>
                </div>

                <div class="uk-card-body">

                    @for($i = 1; $i <= 6; $i++)
                        <div class="uk-margin">
                            <label for="inputChampionShip{{$i}}" class="uk-form-label">Meisterschaft #{{$i}}</label>
                            <div class="uk-form-controls" uk-grid>
                                <input type="text" class="uk-input uk-width-3-4" id="inputChampionShip{{$i}}"
                                       value="{{$exhibition->$price ?? ''}}"
                                       name="championShip[{{$i}}][name]"
                                >
                                <input type="number" class="uk-input uk-width-1-4" id=""
                                       value="{{$exhibition->fee ?? ''}}"
                                       name="championShip[{{$i}}][fee]"
                                >
                            </div>
                            <div class="uk-form-controls">
                                <label><input type="checkbox" class="uk-checkbox" name="championShip[{{$i}}][auto]"
                                              value="1"> automatische Teilnahme</label>
                            </div>

                        </div>
                    @endfor

                    <button type="submit" class="uk-button-primary uk-button">Speichern</button>
                </div>
            </div>
        </div>
    </form>
@endsection
