<?php

namespace App\Http\Controllers;

use App\Exhibitor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ExhibitorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('exhibitor.create');
    }


    public  function setDefault($id)
    {
        $user = Auth::user();
        $user->defaultExhibitor = $id;
        $user->save();

        return redirect()->back();
    }

    public  function setMe($id)
    {
        $user = Auth::user();
        $user->userProfile = $id;
        $user->save();

        return redirect()->back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $exhibitor = new Exhibitor();

        $data = $request->all();
        $data['iban'] = str_replace(' ', '', $data['iban']);

        $user = Auth::user();


        foreach ($data as $k => $v) {
            if (in_array($k, ['_token', '_method', 'exhibitorType'])) {
                continue;
            }
            $exhibitor->$k = $v;
        }
        $exhibitor->type   = $data['exhibitorType'];
        $exhibitor->userId = $user->id;

        $exhibitor->save();

        if(DB::table('exhibitors')->where('userId',$user->id)->count() == 0)
        {
            $user->defaultExhibitor = $exhibitor->id;
            $user->save();
        }


        return redirect()->route('home');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Exhibitor $exhibitor
     * @return \Illuminate\Http\Response
     */
    public function edit(Exhibitor $exhibitor)
    {
        if($exhibitor->userId != Auth::id())
        {
            return redirect()->back();
        }
        return view('exhibitor.edit',compact('exhibitor'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Exhibitor $exhibitor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Exhibitor $exhibitor)
    {

        $data = $request->all();
        $data['iban'] = str_replace(' ', '', $data['iban']);

        foreach ($data as $k => $v) {
            if (in_array($k, ['_token', '_method', 'exhibitorType'])) {
                continue;
            }
            $exhibitor->$k = $v;
        }
        $exhibitor->type   = $data['exhibitorType'] ?? 0;

        $exhibitor->save();

        return redirect()->route('home');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
