<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Animal
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property int $exhibitorId
 * @property int $exhibitionId
 * @property int $breedId
 * @property int $colorId
 * @property string $gender_age
 * @property int $championship
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property int $sellprice
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereBreedId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereChampionship($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereColorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereExhibitionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereExhibitorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereGenderAge($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereSellprice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereUpdatedAt($value)
 * @property int $ownBreeding
 * @property string|null $aocColor
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereAocColor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Animal whereOwnBreeding($value)
 */
class Animal extends Model
{
    protected $fillable = [
        'gender_age',
        'sellprice',
        'exhibitorId',
        'exhibitionId',
        'colorId',
        'breedId'
    ];

    protected function getAnimalKeyAttribute()
    {
        $c = Color::find($this->colorId);

        return implode(':',[$c->groupNo,$c->breedNo,$c->colorNo]);
    }

      protected function getAnimalNameAttribute()
    {
        $c = Color::find($this->colorId);
           $b = Breed::where([
            ["breedNo",$c->breedNo],
            ["groupNo",$c->groupNo]
        ])->first();

        return $b->breedName.' '.$c->colorName;
    }




}
