@servers(['production' => 'ssh-w014649f@w014649f.kasserver.com','stageing' => 'ssh-w014649f@w014649f.kasserver.com'])

@setup
$repository = "ssh://git@gitlab.amadeus-agentur.com:93/amadeus/verlag/onlinemeldebogen.git";

$path_production = "w014649f";
$path_stageing = "w014649f";


if($on == "production")
{
$releases_dir = "/www/htdocs/w014649f/meldebogen.amadeus-verlag.net/releases";
$app_dir = "/www/htdocs/w014649f/meldebogen.amadeus-verlag.net";
}
elseif($on == "stageing")
{
$releases_dir = "/www/htdocs/w014649f/meldebogen.dev.amadeus-verlag.net/releases";
$app_dir = "/www/htdocs/w014649f/meldebogen.dev.amadeus-verlag.net";
}

if($release != null && $release != '' )
{
    $app_release = $release;
}
else $app_release = date('YmdHis');


$new_release_dir = $releases_dir .'/'. $app_release;
@endsetup


@story('deploy',["on" => $on])
clone_repository
run_composer
update_symlinks
@endstory


@task('clone_repository')
echo 'Cloning repository'
echo 'Version: {{$app_release}}';
[ -d {{ $new_release_dir }} ] || echo "creating dir" && mkdir -p {{ $new_release_dir }}
git clone --depth 1 {{ $repository }} {{ $new_release_dir }}
echo "setting version"
sed -i "s/dev-master/{{$app_release}}/g" {{$new_release_dir}}/config/app.php
@endtask

@task('run_composer')
echo "Starting deployment ({{ $app_release }})"
cd {{ $new_release_dir }}
php72 {{$app_dir}}/../bin/composer.phar install --no-dev --prefer-dist --no-scripts -q -o
php72 artisan package:discover
@endtask

@task('update_symlinks')

echo "Linking storage directory"
rm -rf {{ $new_release_dir }}/storage
ln -nfs {{ $app_dir }}/storage {{ $new_release_dir }}/storage
ln -nfs {{ $app_dir }}/storage/app/public {{ $new_release_dir }}/public/storage

echo 'Linking .env file'
ln -nfs {{ $app_dir }}/.env {{ $new_release_dir }}/.env

echo 'Linking current release'
ln -nfs {{ $new_release_dir }} {{ $app_dir }}/current
@endtask
