@extends('layouts.app')
@section('content')
    <div class="uk-container">

        @if($registration->locked)
            <div class="uk-alert uk-alert-default">
                <span uk-icon="icon: info"></span>
                Wir haben Ihren Meldebogen bereits erhalten.
            </div>

        @endif

        <div uk-grid class="uk-grid-medium">
            <div class="uk-width-3-4@m">
                <h2 class="uk-margin-small-bottom">Ihre Meldung zur</h2>
                <h3>{{$exhibition->name}}</h3>
            </div>
            <div class="uk-width-1-4@m">
                @if(\Carbon\Carbon::now()->lte( \Carbon\Carbon::parse($exhibition->registrationEnd)->addDays(1) ))
                    <a class="uk-button uk-button-default uk-width-1-1 uk-margin-small-bottom" href="/exhibition">Meldebogen
                        beenden</a>
                    @if(!$registration->locked)
                        <a class="uk-button uk-button-primary uk-width-1-1"
                           href="/anmeldung/{{$registration->id}}/send">Meldebogen
                            absenden</a>
                    @endif


                @endif
            </div>
        </div>

        <hr>

        <div class="uk-grid-medium " uk-grid uk-height-match="target: .uk-card-body">
            @include('registration.cards.exhibitor')
            @include('registration.cards.prizes')
            @include('registration.cards.costs')
        </div>
        <hr>
        @include('registration.partials.show_navigation')
        <hr>

        @include('registration.animals.single-card')
        @include('registration.animals.pair-card')
        @include('registration.animals.aviary-card')
        <hr>
        @include('registration.championship.carddeck')


    </div>
@endsection

@section('modal')
    <button class="uk-modal-close-default" type="button" uk-close></button>
    <div class="modal-content">
        <div class="uk-modal-header">
            <h5 class="uk-modal-title">AOC Farbe</h5>
        </div>
        <div class="uk-modal-body">
            <p>Bitte AOC Farbe eingeben:</p>
            <input type="text" name="aocColor" class="uk-input" placeholder="Hier AOC Farbe eingeben">
        </div>
        <div class="uk-modal-footer">
            <button type="button" class="uk-button uk-button-primary">Speichern</button>
            <button type="button" class="uk-button uk-button-default" uk-close>Abbrechen</button>
        </div>
    </div>
@endsection

