<?php

namespace App\Helper;

use App\Championship;
use App\ChampionshipParticipation;
use App\Color;
use App\Breed;
use App\Exhibition;
use App\Exhibitor;
use App\Registration;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;

/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 29.05.18
 * Time: 16:31
 */
class AdminHelper
{

    public static function getChampionShipAnimals($animals)
    {
        $championship = [];

        foreach ($animals as $animal) {
            $animalColor = Color::find($animal->color);
            $championship[] = implode(':', [$animalColor->groupNo, $animalColor->breedNo, $animalColor->colorNo]);
        }
        return array_unique($championship);
    }

    public static function getChampionshipCount($animals)
    {
        return count(self::getChampionShipAnimals($animals));
    }

    public static function getReadableAnimalNames($animals)
    {
        $championship = [];

        foreach ($animals as $animal) {
            $animalColor = Color::find($animal->colorId);

            if ($animalColor->colorNo == "910") continue; // AOC ist ausgeschlossen... weil isso;

            $animalBreed = Breed::find($animal->breedId);
            $championship[$animal->colorId] = $animalBreed->breedName . " " . $animalColor->colorName;
        }
        return array_unique($championship);
    }

    public static function getParticipations(Championship $championship,$exhibitorId)
    {

        $cs = ChampionshipParticipation::where('exhibitorId', $exhibitorId)->where('championshipId',$championship->id)->get(['colorId'])->toArray();

        $colors = [];
        foreach($cs as $p)
        {
            $colors[] = $p['colorId'];
        }
        return $colors;
    }
}