@extends('layouts.app')

@section('content')


    <div class="uk-container">
        @if(session('status'))
            <div class="uk-alert uk-alert-success uk-width-2-3  uk-align-center">
                {{ session('status') }}
            </div>
        @endif


        @if ($errors->has('email'))
            <div class="uk-alert uk-alert-warning uk-width-2-3">
                <strong>{{ $errors->first('email') }}</strong>
            </div>
        @endif

        <div>
            <div class="uk-card uk-card-default uk-width-2-3@m uk-align-center">

                <div class="uk-card-header">
                    <h3 class="uk-card-title">{{ __('Reset Password') }}</h3>
                </div>

                <div class=" uk-card-body ">
                    <form class="uk-form-horizontal uk-margin-large" method="POST"
                          action="{{ route('password.email') }}">

                        @csrf

                        <div class="uk-margin">
                            <label class="uk-form-label" for="email">{{ __('auth.emailaddress') }}</label>
                            <div class="uk-form-controls">
                                <input id="email" type="email"
                                       class="uk-input {{ $errors->has('email') ? ' is-invalid' : '' }}"
                                       name="email" value="{{ old('email') }}" required autofocus>

                                @if ($errors->has('email'))
                                    <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="uk-margin">
                            <div class="uk-form-controls">
                                <input type="submit" class="uk-button uk-button-primary"
                                       value="{{ __('Überprüfen') }}">
                            </div>
                        </div>


                    </form>

                </div>
                <div class="uk-card-footer">
                    Noch kein Benutzerkonto erstellt? <a href="/register">Hier gehts zur Benutzerkontoerstellung</a>
                </div>
            </div>
        </div>
@endsection
