<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddChampionshipColumnToAllAnimalTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('animal_aviaries', function (Blueprint $table) {
            $table->boolean('championship')->default(false)->after('sellprice');
        });

        Schema::table('animal_pairs', function (Blueprint $table) {
            $table->boolean('championship')->default(false)->after('sellprice');
        });

        Schema::table('animals', function (Blueprint $table) {
            $table->boolean('championship')->default(false)->after('gender_age');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('animal_aviaries', function (Blueprint $table) {
            $table->dropColumn('championship');
        });

        Schema::table('animal_pairs', function (Blueprint $table) {
            $table->dropColumn('championship');
        });

        Schema::table('animals', function (Blueprint $table) {
            $table->dropColumn('championship');
        });
    }

}
