<?php

namespace App\Console\Commands;

use App\Registration;
use Carbon\Carbon;
use Illuminate\Console\Command;

class LockMeldebogen extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'lock:registrations';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Will lock all Send Registrations';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $regs = Registration::where('send_at','!=',NULL)->where('locked',0)->get();


        foreach($regs as $reg)
        {
            if(Carbon::parse($reg->send_at)->addDay()->lte(Carbon::now()))
            {
                $reg->locked = true;
                $reg->save();
            }

        }
        $this->warn('Done');

    }
}
